/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.MobSpawning;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends class_2248
implements class_2343,
class_3737 {
    private static final class_2746 WATERLOGGED = class_2741.field_12508;

    public PipeBlock(class_4970.class_2251 settings) {
        super(settings.method_26235(MobSpawning.NO_SPAWN).method_22488().method_26236((s, p, w) -> false));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PipeBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(pos);
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private static boolean isPartHit(class_265 shape, class_3965 hit) {
        class_2338 pos = hit.method_17777();
        class_243 posInBlock = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        for (class_238 box : shape.method_1090()) {
            class_243 dir;
            if (!box.method_1006(posInBlock.method_1019(dir = box.method_1005().method_1020(posInBlock).method_1029().method_1021(1.0E-4)))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PipeVoxelShape getHitPart(PipeBlockEntity pipe, class_3965 hit) {
        for (PipeVoxelShape partShape : pipe.getPartShapes()) {
            if (!PipeBlock.isPartHit(partShape.shape, hit)) continue;
            return partShape;
        }
        return null;
    }

    @Nullable
    private static PipeVoxelShape getTargetedPart(class_1922 blockView, class_2338 pos) {
        class_1937 world;
        if (!(blockView instanceof class_1937) || !(world = (class_1937)blockView).method_8608()) {
            return null;
        }
        PipeVoxelShape currentBest = null;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)class_25862;
            double smallestDistance = 10000.0;
            for (PipeVoxelShape pipePartShape : pipe.getPartShapes()) {
                double dist;
                class_265 partShape = pipePartShape.shape;
                float tickDelta = class_310.method_1551().method_1488();
                class_746 player = class_310.method_1551().field_1724;
                class_243 vec3d = player.method_5836(tickDelta);
                class_243 vec3d2 = player.method_5828(tickDelta);
                double maxDistance = class_310.method_1551().field_1761.method_2904();
                class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * maxDistance, vec3d2.field_1351 * maxDistance, vec3d2.field_1350 * maxDistance);
                class_3965 hit = partShape.method_1092(vec3d, vec3d3, pos);
                if (hit == null || !PipeBlock.isPartHit(partShape, hit) || !((dist = hit.method_17784().method_1022(vec3d)) < smallestDistance)) continue;
                smallestDistance = dist;
                currentBest = pipePartShape;
            }
        }
        return currentBest;
    }

    static boolean useWrench(PipeBlockEntity pipe, class_1657 player, class_1268 hand, class_3965 hit) {
        PipeVoxelShape partShape = PipeBlock.getHitPart(pipe, hit);
        if (partShape == null) {
            return false;
        }
        class_2498 group = pipe.method_11010().method_26231();
        class_2338 blockPos = pipe.method_11016();
        class_1937 world = pipe.method_10997();
        class_243 hitPos = hit.method_17784();
        if (player != null && player.method_5715()) {
            boolean removeBlock;
            boolean bl = removeBlock = pipe.connections.size() == 1;
            if (!world.field_9236) {
                pipe.removePipeAndDropContainedItems(partShape.type);
            }
            if (removeBlock) {
                world.method_8501(blockPos, class_2246.field_10124.method_9564());
            }
            world.method_8408(blockPos, class_2246.field_10124);
            world.method_8649((class_1297)new class_1542(world, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, new class_1799((class_1935)MIPipes.INSTANCE.getPipeItem(partShape.type))));
            world.method_8396(player, blockPos, group.method_10595(), class_3419.field_15245, (group.method_10597() + 1.0f) / 2.0f, group.method_10599() * 0.8f);
        } else {
            class_3414 sound = null;
            if (partShape.direction == null) {
                if (!world.field_9236) {
                    pipe.addConnection(partShape.type, hit.method_17780());
                } else {
                    sound = group.method_10598();
                }
            } else if (!world.field_9236) {
                pipe.removeConnection(partShape.type, partShape.direction);
            } else {
                sound = group.method_10595();
            }
            world.method_8408(blockPos, class_2246.field_10124);
            if (sound != null) {
                world.method_8396(player, blockPos, sound, class_3419.field_15245, (group.method_10597() + 1.0f) / 4.0f, group.method_10599() * 0.8f);
            }
        }
        return true;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hit) {
        PipeBlockEntity pipeEntity = (PipeBlockEntity)world.method_8321(blockPos);
        PipeVoxelShape partShape = PipeBlock.getHitPart(pipeEntity, hit);
        if (partShape != null && partShape.opensGui) {
            if (!world.field_9236) {
                player.method_17355((class_3908)pipeEntity.getGui(partShape.type, partShape.direction));
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        class_47 lootContext = builder.method_312(class_181.field_1224, (Object)state).method_309(class_173.field_1172);
        PipeBlockEntity pipeEntity = (PipeBlockEntity)lootContext.method_296(class_181.field_1228);
        ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
        for (PipeNetworkNode node : pipeEntity.getNodes()) {
            droppedStacks.add(new class_1799((class_1935)MIPipes.INSTANCE.getPipeItem(node.getType())));
            node.appendDroppedStacks(droppedStacks);
        }
        return droppedStacks;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        PipeVoxelShape targetedPart = PipeBlock.getTargetedPart(world, pos);
        return new class_1799((class_1935)(targetedPart == null ? class_1802.field_8162 : MIPipes.INSTANCE.getPipeItem(targetedPart.type)));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            ((PipeBlockEntity)world.method_8321(pos)).updateConnections();
        }
        super.method_9612(state, world, pos, block, fromPos, notify);
    }

    public int method_9505(class_2680 state, class_1922 world, class_2338 pos) {
        return 0;
    }

    public boolean method_9543() {
        return true;
    }

    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9549(state, world, pos, context);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        PipeVoxelShape targetedPart = PipeBlock.getTargetedPart(world, pos);
        return targetedPart != null ? targetedPart.shape : PipeBlockEntity.DEFAULT_SHAPE;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return this.method_9549(state, world, pos, null);
    }

    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return this.method_9549(state, world, pos, null);
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return this.method_9549(state, world, pos, null);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof PipeBlockEntity)) {
            return PipeBlockEntity.DEFAULT_SHAPE;
        }
        PipeBlockEntity entity = (PipeBlockEntity)be;
        return entity.currentCollisionShape;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)class_25862;
                pipe.stateReplaced = true;
            }
            world.method_8544(pos);
        }
    }
}

