/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.api;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.WorldHelper;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class PipeNetworkManager {
    private final Map<class_2338, PipeNetwork> networkByBlock = new HashMap<class_2338, PipeNetwork>();
    private final Map<class_2338, Set<class_2350>> links = new HashMap<class_2338, Set<class_2350>>();
    private final Set<PipeNetwork> networks = new HashSet<PipeNetwork>();
    private int nextNetworkId = 0;
    private final PipeNetworkType type;
    private final Map<Long, Set<class_2338>> spannedChunks = new HashMap<Long, Set<class_2338>>();
    protected LongSet tickingChunks = new LongOpenHashSet();
    protected LongSet lastTickingChunks = new LongOpenHashSet();

    public PipeNetworkManager(PipeNetworkType type) {
        this.type = type;
    }

    public void tickNetworks(class_3218 world) {
        this.updateTickingChunks(world);
        for (PipeNetwork network : this.networks) {
            network.tick(world);
        }
        LongIterator longIterator = this.tickingChunks.iterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            long chunkPos = (Long)longIterator.next();
            int chunkX = class_1923.method_8325((long)chunkPos);
            class_2791 chunk = world.method_8402(chunkX, chunkZ = class_1923.method_8332((long)chunkPos), class_2806.field_12803, false);
            if (chunk != null) {
                chunk.method_12008(true);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("MI pipes issue: ticking spanned chunk was not loaded anymore. Please report this.\n");
            sb.append(" - Pipe type: ").append(this.type.getIdentifier()).append("\n");
            sb.append(" - Chunk: %d,%d\n".formatted(chunkX, chunkZ));
            sb.append(" - Blocks in chunk:\n");
            Iterator it = this.spannedChunks.get(chunkPos).stream().sorted().iterator();
            while (it.hasNext()) {
                class_2338 pos = (class_2338)it.next();
                sb.append("   - Pos: %d %d %d\n".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                PipeNetwork network = this.networkByBlock.get(pos);
                String node = network == null ? "none" : (network.getNode(pos) == null ? "not loaded" : "loaded");
                sb.append("   - Has network (should be true): %s\n".formatted(network != null));
                sb.append("   - Node status (should be loaded): %s\n".formatted(node));
            }
            throw new UnsupportedOperationException(sb.toString());
        }
    }

    public boolean hasNode(class_2338 pos) {
        return this.networkByBlock.containsKey(pos);
    }

    private void updateTickingChunks(class_3218 world) {
        LongSet tmp = this.tickingChunks;
        this.tickingChunks = this.lastTickingChunks;
        this.lastTickingChunks = tmp;
        Preconditions.checkState((boolean)this.tickingChunks.isEmpty(), (Object)"Internal pipe network error.");
        for (Map.Entry<Long, Set<class_2338>> entry : this.spannedChunks.entrySet()) {
            long chunk = entry.getKey();
            if (!WorldHelper.isChunkTicking(world, chunk)) continue;
            this.tickingChunks.add(chunk);
            if (this.lastTickingChunks.remove(chunk)) continue;
            this.notifyTickingChanged(entry.getValue());
        }
        for (Long notTickingChunk : this.lastTickingChunks) {
            this.notifyTickingChanged(this.spannedChunks.get(notTickingChunk));
        }
        this.lastTickingChunks.clear();
    }

    private void notifyTickingChanged(@Nullable Set<class_2338> positionsInChunk) {
        if (positionsInChunk != null) {
            for (class_2338 pos : positionsInChunk) {
                PipeNetwork network = this.networkByBlock.get(pos);
                network.tickingCacheValid = false;
            }
        }
    }

    public void addLink(class_2338 pos, class_2350 direction, boolean force) {
        if (this.hasLink(pos, direction)) {
            return;
        }
        if (!this.canLink(pos, direction, force)) {
            return;
        }
        class_2338 otherPos = pos.method_10093(direction);
        this.links.get(pos).add(direction);
        this.links.get(otherPos).add(direction.method_10153());
        PipeNetwork network = this.networkByBlock.get(pos);
        PipeNetwork otherNetwork = this.networkByBlock.get(otherPos);
        if (network != otherNetwork) {
            if (!network.data.equals(otherNetwork.data)) {
                network.data = network.merge(otherNetwork);
            }
            for (Map.Entry<class_2338, PipeNetworkNode> entry : otherNetwork.getRawNodeMap().entrySet()) {
                PipeNetworkNode node = entry.getValue();
                class_2338 nodePos = entry.getKey();
                if (node != null) {
                    node.network = network;
                }
                this.networkByBlock.put(nodePos, network);
                network.setNode(nodePos, node);
            }
            this.networks.remove(otherNetwork);
        }
        network.tickingCacheValid = false;
        this.checkStateCoherence();
    }

    public void removeLink(class_2338 pos, class_2350 direction) {
        if (!this.hasLink(pos, direction)) {
            return;
        }
        class_2338 otherPos = pos.method_10093(direction);
        this.links.get(pos).remove(direction);
        this.links.get(otherPos).remove(direction.method_10153());
        PipeNetwork network = this.networkByBlock.get(pos);
        final HashMap<class_2338, PipeNetworkNode> unvisitedNodes = new HashMap<class_2338, PipeNetworkNode>(network.getRawNodeMap());
        network.tickingCacheValid = false;
        class Dfs {
            Dfs() {
            }

            private void dfs(class_2338 currentPos) {
                if (!unvisitedNodes.containsKey(currentPos)) {
                    return;
                }
                unvisitedNodes.remove(currentPos);
                for (class_2350 direction : PipeNetworkManager.this.links.get(currentPos)) {
                    this.dfs(currentPos.method_10093(direction));
                }
            }
        }
        Dfs dfs = new Dfs();
        dfs.dfs(pos);
        if (unvisitedNodes.size() > 0) {
            PipeNetwork newNetwork = this.createNetwork(network.data.clone());
            for (Map.Entry entry : unvisitedNodes.entrySet()) {
                PipeNetworkNode node = (PipeNetworkNode)entry.getValue();
                class_2338 nodePos = (class_2338)entry.getKey();
                if (node != null) {
                    node.network = newNetwork;
                }
                this.networkByBlock.put(nodePos, newNetwork);
                newNetwork.setNode(nodePos, node);
                network.removeNode(nodePos);
            }
        }
        this.checkStateCoherence();
    }

    public boolean hasLink(class_2338 pos, class_2350 direction) {
        Set<class_2350> nodeLinks = this.links.get(pos);
        return nodeLinks != null && nodeLinks.contains(direction);
    }

    public boolean canLink(class_2338 pos, class_2350 direction, boolean forceLink) {
        class_2338 otherPos = pos.method_10093(direction);
        PipeNetwork network = this.networkByBlock.get(pos);
        PipeNetwork otherNetwork = this.networkByBlock.get(otherPos);
        return otherNetwork != null && (network.data.equals(otherNetwork.data) || forceLink && network.merge(otherNetwork) != null);
    }

    public void addNode(PipeNetworkNode node, class_2338 pos, PipeNetworkData data) {
        if (this.networkByBlock.containsKey(pos)) {
            throw new IllegalArgumentException("Cannot add a node that is already in the network.");
        }
        PipeNetwork network = this.createNetwork(data.clone());
        if (node != null) {
            node.network = network;
        }
        this.networkByBlock.put(pos.method_10062(), network);
        this.incrementSpanned(pos);
        network.setNode(pos, node);
        this.links.put(pos.method_10062(), new HashSet());
        this.checkStateCoherence();
    }

    public void removeNode(class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            this.removeLink(pos, direction);
        }
        PipeNetwork network = this.networkByBlock.remove(pos);
        this.decrementSpanned(pos);
        this.networks.remove(network);
        this.links.remove(pos);
        this.checkStateCoherence();
    }

    public void nodeLoaded(PipeNetworkNode node, class_2338 pos) {
        PipeNetwork network = this.networkByBlock.get(pos);
        if (network == null) {
            PipeNetworkData data = MIPipes.INSTANCE.getPipeItem((PipeNetworkType)this.getType()).defaultData;
            this.addNode(node, pos, data);
            for (class_2350 direction : class_2350.values()) {
                this.addLink(pos, direction, false);
            }
        } else {
            node.network = network;
            network.setNode(pos, node);
            network.tickingCacheValid = false;
        }
        this.incrementSpanned(pos);
        this.checkStateCoherence();
    }

    public void nodeUnloaded(PipeNetworkNode node, class_2338 pos) {
        node.network.setNode(pos, null);
        node.network.tickingCacheValid = false;
        this.decrementSpanned(pos);
        this.checkStateCoherence();
    }

    private PipeNetwork createNetwork(PipeNetworkData data) {
        PipeNetwork network = this.type.getNetworkCtor().apply(this.nextNetworkId, data);
        network.manager = this;
        ++this.nextNetworkId;
        this.networks.add(network);
        this.checkStateCoherence();
        return network;
    }

    private void incrementSpanned(class_2338 pos) {
        this.spannedChunks.computeIfAbsent(class_1923.method_37232((class_2338)pos), p -> new HashSet()).add(pos.method_10062());
    }

    private void decrementSpanned(class_2338 pos) {
        long chunkPos = class_1923.method_37232((class_2338)pos);
        Set<class_2338> set = this.spannedChunks.get(chunkPos);
        set.remove(pos);
        if (set.size() == 0) {
            this.spannedChunks.remove(chunkPos);
        }
    }

    public void fromNbt(class_2487 tag) {
        class_2499 networksTag = tag.method_10554("networks", (int)new class_2487().method_10711());
        for (Object networkTag : networksTag) {
            PipeNetwork network = this.type.getNetworkCtor().apply(-1, null);
            network.manager = this;
            network.fromTag((class_2487)networkTag);
            this.networks.add(network);
        }
        HashMap<Integer, PipeNetwork> networkIds = new HashMap<Integer, PipeNetwork>();
        for (PipeNetwork network : this.networks) {
            networkIds.put(network.id, network);
        }
        int[] data = tag.method_10561("networkByBlock");
        for (int i = 0; i < data.length / 5; ++i) {
            PipeNetwork network = (PipeNetwork)networkIds.get(data[5 * i + 3]);
            class_2338 pos = new class_2338(data[5 * i], data[5 * i + 1], data[5 * i + 2]);
            this.networkByBlock.put(pos, network);
            network.setNode(pos, null);
            this.links.put(pos, new HashSet<class_2350>(Arrays.asList(NbtHelper.decodeDirections((byte)data[5 * i + 4]))));
        }
        this.nextNetworkId = tag.method_10550("nextNetworkId");
        this.checkStateCoherence();
    }

    public class_2487 toTag(class_2487 tag) {
        ArrayList<class_2487> networksTags = new ArrayList<class_2487>();
        for (PipeNetwork network : this.networks) {
            networksTags.add(network.toTag(new class_2487()));
        }
        class_2499 networksTag = new class_2499();
        networksTag.addAll(networksTags);
        tag.method_10566("networks", (class_2520)networksTag);
        int[] networkByBlockData = new int[this.networkByBlock.size() * 5];
        int i = 0;
        for (Map.Entry<class_2338, PipeNetwork> entry : this.networkByBlock.entrySet()) {
            networkByBlockData[i++] = entry.getKey().method_10263();
            networkByBlockData[i++] = entry.getKey().method_10264();
            networkByBlockData[i++] = entry.getKey().method_10260();
            networkByBlockData[i++] = entry.getValue().id;
            networkByBlockData[i++] = NbtHelper.encodeDirections((Iterable<class_2350>)this.links.get(entry.getKey()));
        }
        tag.method_10539("networkByBlock", networkByBlockData);
        tag.method_10569("nextNetworkId", this.nextNetworkId);
        this.checkStateCoherence();
        return tag;
    }

    public PipeNetworkType getType() {
        return this.type;
    }

    public Set<class_2350> getNodeLinks(class_2338 pos) {
        return new HashSet<class_2350>((Collection)this.links.get(pos));
    }

    public void checkStateCoherence() {
        this.customAssert(this.networkByBlock.keySet().equals(this.links.keySet()));
        for (Map.Entry<class_2338, PipeNetwork> entry : this.networkByBlock.entrySet()) {
            this.customAssert(this.networks.contains(entry.getValue()));
            PipeNetworkNode node = entry.getValue().getNode(entry.getKey());
            this.customAssert(node == null || node.network == entry.getValue());
        }
        for (Map.Entry<class_2338, Object> entry : this.links.entrySet()) {
            this.customAssert(entry.getValue() != null);
        }
        for (PipeNetwork pipeNetwork : this.networks) {
            for (Map.Entry<class_2338, PipeNetworkNode> entry : pipeNetwork.getRawNodeMap().entrySet()) {
                this.customAssert(entry.getValue() == null || entry.getValue().network == pipeNetwork);
                this.customAssert(this.networkByBlock.get(entry.getKey()) == pipeNetwork);
            }
        }
    }

    private void customAssert(boolean predicate) {
        if (!predicate) {
            throw new NullPointerException("Predicate was false");
        }
    }
}

