/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.api;

import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class PipeNetwork {
    protected int id;
    public PipeNetworkManager manager;
    public PipeNetworkData data;
    private final Map<class_2338, PipeNetworkNode> nodes = new HashMap<class_2338, PipeNetworkNode>();
    private final Map<Long, Map<class_2338, PipeNetworkNode>> nodesByChunk = new HashMap<Long, Map<class_2338, PipeNetworkNode>>();
    private final List<PosNode> tickingNodesCache = new ArrayList<PosNode>();
    boolean tickingCacheValid = false;

    public PipeNetwork(int id, PipeNetworkData data) {
        this.id = id;
        this.data = data;
    }

    public void fromTag(class_2487 tag) {
        this.id = tag.method_10550("id");
        this.data.fromTag(tag.method_10562("data"));
    }

    public class_2487 toTag(class_2487 tag) {
        tag.method_10569("id", this.id);
        tag.method_10566("data", (class_2520)this.data.toTag(new class_2487()));
        return tag;
    }

    public void tick(class_3218 world) {
    }

    public PipeNetworkData merge(PipeNetwork other) {
        return null;
    }

    @Nullable
    public PipeNetworkNode getNode(class_2338 pos) {
        return this.nodes.get(pos);
    }

    public void setNode(class_2338 pos, @Nullable PipeNetworkNode node) {
        this.nodes.put(pos.method_10062(), node);
        this.nodesByChunk.computeIfAbsent(class_1923.method_37232((class_2338)pos), p -> new HashMap()).put(pos.method_10062(), node);
    }

    public void removeNode(class_2338 pos) {
        this.nodes.remove(pos);
        long chunk = class_1923.method_37232((class_2338)pos);
        Map<class_2338, PipeNetworkNode> map = this.nodesByChunk.get(chunk);
        map.remove(pos);
        if (map.size() == 0) {
            this.nodesByChunk.remove(chunk);
        }
    }

    public Map<class_2338, PipeNetworkNode> getRawNodeMap() {
        return Collections.unmodifiableMap(this.nodes);
    }

    protected Collection<PosNode> iterateTickingNodes() {
        if (!this.tickingCacheValid) {
            this.tickingNodesCache.clear();
            for (Map.Entry<Long, Map<class_2338, PipeNetworkNode>> chunkEntry : this.nodesByChunk.entrySet()) {
                if (!this.manager.tickingChunks.contains((Object)chunkEntry.getKey())) continue;
                for (Map.Entry<class_2338, PipeNetworkNode> entry : chunkEntry.getValue().entrySet()) {
                    PipeNetworkNode node = entry.getValue();
                    if (node == null) continue;
                    this.tickingNodesCache.add(new PosNode(entry.getKey(), node));
                }
            }
            this.tickingCacheValid = true;
        }
        return this.tickingNodesCache;
    }

    protected static class PosNode {
        private final class_2338 pos;
        private final PipeNetworkNode node;

        public PosNode(class_2338 pos, PipeNetworkNode node) {
            this.pos = pos;
            this.node = node;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public PipeNetworkNode getNode() {
            return this.node;
        }
    }
}

