/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearGrid;
import aztech.modern_industrialization.nuclear.INuclearTile;
import aztech.modern_industrialization.nuclear.NeutronFate;
import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import java.util.Optional;
import java.util.Random;

public class NuclearGridHelper {
    private static final int[] dX = new int[]{1, 0, -1, 0};
    private static final int[] dY = new int[]{0, 1, 0, -1};
    private static final Random rand = new Random();
    private static final int MAX_STEP = 100;
    private static final int MAX_SPLIT = 30;

    public static boolean simulate(INuclearGrid grid) {
        INuclearTile tile;
        int sizeX = grid.getSizeX();
        int sizeY = grid.getSizeY();
        boolean hasFuel = false;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                int x = i;
                int y = j;
                Optional<INuclearTile> maybeTile = grid.getNuclearTile(i, j);
                if (!maybeTile.isPresent()) continue;
                tile = maybeTile.get();
                Optional<NuclearFuel> maybeFuel = tile.getFuel();
                int neutronNumberPrime = tile.neutronGenerationTick(grid);
                if (neutronNumberPrime <= 0) continue;
                if (maybeFuel.isEmpty()) {
                    throw new IllegalStateException("Neutron generated without fuel");
                }
                hasFuel = true;
                NuclearFuel fuel = maybeFuel.get();
                tile.putHeat((double)(neutronNumberPrime * fuel.directEUbyDesintegration) / fuel.neutronMultiplicationFactor);
                int split = Math.min(neutronNumberPrime, 30);
                int neutronNumberPerSplit = neutronNumberPrime / split;
                block2: for (int k = 0; k < split + 1; ++k) {
                    int neutronNumber;
                    int n = neutronNumber = k < split ? neutronNumberPerSplit : neutronNumberPrime % split;
                    if (neutronNumber <= 0) continue;
                    NeutronType type = NeutronType.FAST;
                    grid.registerNeutronCreation(neutronNumber, type);
                    int dir = rand.nextInt(4);
                    int step = 0;
                    int posX = x;
                    int posY = y;
                    while (step < 100) {
                        block19: {
                            block18: {
                                double probaAbsorption;
                                ++step;
                                Optional<INuclearTile> maybeSecondTile = grid.getNuclearTile(posX, posY);
                                if (!maybeSecondTile.isPresent()) break block18;
                                INuclearTile secondTile = maybeSecondTile.get();
                                secondTile.addNeutronsToFlux(neutronNumber, type);
                                if (!secondTile.getComponent().isPresent()) break block19;
                                INuclearComponent component = secondTile.getComponent().get();
                                double interactionProba = component.getNeutronBehaviour().interactionTotalProbability(type);
                                if (!(rand.nextDouble() < interactionProba)) break block19;
                                double interactionSelector = rand.nextDouble();
                                if (interactionSelector <= (probaAbsorption = component.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.ABSORPTION))) {
                                    secondTile.absorbNeutrons(neutronNumber, type);
                                    if (type == NeutronType.FAST) {
                                        secondTile.putHeat(neutronNumber * 8);
                                    }
                                    if (secondTile.getFuel().isPresent()) {
                                        grid.registerNeutronFate(neutronNumber, type, NeutronFate.ABSORBED_IN_FUEL);
                                        continue block2;
                                    }
                                    grid.registerNeutronFate(neutronNumber, type, NeutronFate.ABSORBED_NOT_IN_FUEL);
                                    continue block2;
                                }
                                dir = rand.nextInt(4);
                                if (type != NeutronType.FAST || !(rand.nextDouble() < component.getNeutronBehaviour().neutronSlowingProbability())) break block19;
                                type = NeutronType.THERMAL;
                                secondTile.putHeat(neutronNumber * 8);
                                break block19;
                            }
                            grid.registerNeutronFate(neutronNumber, type, NeutronFate.ESCAPE);
                            continue block2;
                        }
                        posX += dX[dir];
                        posY += dY[dir];
                    }
                }
            }
        }
        double[][] temperatureOut = new double[sizeX][sizeY];
        double[][] temperatureDelta = new double[sizeX][sizeY];
        for (int step = 0; step < 3; ++step) {
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeY; ++j) {
                    Optional<INuclearTile> maybeTile = grid.getNuclearTile(i, j);
                    if (!maybeTile.isPresent()) continue;
                    INuclearTile tile2 = maybeTile.get();
                    double temperatureA = tile2.getTemperature();
                    if (step == 2) {
                        tile2.setTemperature(temperatureA + temperatureDelta[i][j]);
                        continue;
                    }
                    if (step == 1) {
                        double[] dArray = temperatureDelta[i];
                        int n = j;
                        dArray[n] = dArray[n] - Math.min(temperatureA, temperatureOut[i][j]);
                    }
                    for (int k = 0; k < 4; ++k) {
                        int i2 = i + dX[k];
                        int j2 = j + dY[k];
                        Optional<INuclearTile> maybeSecondTile = grid.getNuclearTile(i2, j2);
                        if (maybeSecondTile.isPresent()) {
                            INuclearTile secondTile = maybeSecondTile.get();
                            double temperatureB = secondTile.getTemperature();
                            double coeffTransfer = 0.5 * (tile2.getHeatTransferCoeff() + secondTile.getHeatTransferCoeff());
                            if (!(temperatureA > temperatureB)) continue;
                            if (step == 0) {
                                double[] dArray = temperatureOut[i];
                                int n = j;
                                dArray[n] = dArray[n] + (temperatureA - temperatureB) * coeffTransfer;
                                continue;
                            }
                            double frac = Math.min(1.0, temperatureA / temperatureOut[i][j]);
                            double[] dArray = temperatureDelta[i2];
                            int n = j2;
                            dArray[n] = dArray[n] + frac * (temperatureA - temperatureB) * coeffTransfer;
                            continue;
                        }
                        double temperatureB = 0.0;
                        double coeffTransfer = 0.5 * tile2.getHeatTransferCoeff();
                        if (step != 0) continue;
                        double[] dArray = temperatureOut[i];
                        int n = j;
                        dArray[n] = dArray[n] + (temperatureA - temperatureB) * coeffTransfer;
                    }
                }
            }
        }
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                Optional<INuclearTile> maybeTile = grid.getNuclearTile(i, j);
                if (!maybeTile.isPresent()) continue;
                tile = maybeTile.get();
                tile.nuclearTick(grid);
            }
        }
        return hasFuel;
    }
}

