/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public interface INuclearComponent<T extends TransferVariant> {
    public double getHeatConduction();

    public INeutronBehaviour getNeutronBehaviour();

    public T getVariant();

    default public T getNeutronProduct() {
        return null;
    }

    default public long getNeutronProductAmount() {
        return 0L;
    }

    default public double getNeutronProductProbability() {
        return 1.0;
    }

    default public int getMaxTemperature() {
        return Integer.MAX_VALUE;
    }

    public static INuclearComponent of(final FluidVariant variant, final double heatConduction, final double density, final NuclearConstant.ScatteringType type, final NuclearConstant.IsotopeParams params, final FluidVariant neutronProduct, final boolean highPressure) {
        return new INuclearComponent<FluidVariant>(){

            @Override
            public double getHeatConduction() {
                return heatConduction * density;
            }

            @Override
            public INeutronBehaviour getNeutronBehaviour() {
                return INeutronBehaviour.of(type, params, density);
            }

            @Override
            public FluidVariant getVariant() {
                return variant;
            }

            @Override
            public FluidVariant getNeutronProduct() {
                return neutronProduct;
            }

            @Override
            public long getNeutronProductAmount() {
                return highPressure ? 8L : 1L;
            }

            @Override
            public double getNeutronProductProbability() {
                return highPressure ? 0.125 : 1.0;
            }
        };
    }

    public static INuclearComponent of(FluidVariant fluid) {
        if (fluid.equals(FluidVariant.of((class_3611)class_3612.field_15910))) {
            return INuclearComponent.of(fluid, 0.05, 1.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), false);
        }
        if (fluid.equals(MIFluids.HEAVY_WATER.variant())) {
            return INuclearComponent.of(fluid, 0.06, 1.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), false);
        }
        if (fluid.equals(MIFluids.HIGH_PRESSURE_WATER.variant())) {
            return INuclearComponent.of(fluid, 0.05, 4.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), true);
        }
        if (fluid.equals(MIFluids.HIGH_PRESSURE_HEAVY_WATER.variant())) {
            return INuclearComponent.of(fluid, 0.06, 4.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), true);
        }
        return null;
    }
}

