/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.misc.version;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.ModernIndustrialization;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Scanner;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class VersionEvents {
    private static final String url = "https://api.cfwidget.com/minecraft/mc-mods/modern-industrialization";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private static final String alphaPostfix = "alpha";

    private static Version fetchVersion(boolean isIncludeAlphaVersion) throws Exception {
        String mcVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
        URLConnection connection = new URL(url).openConnection();
        try (Scanner scanner = new Scanner(connection.getInputStream());){
            PriorityQueue<Version> queue = new PriorityQueue<Version>();
            String response = scanner.useDelimiter("\\A").next();
            JsonObject jo = (JsonObject)JsonParser.parseString((String)response);
            for (JsonElement file : jo.getAsJsonArray("files")) {
                JsonObject fileAsJsonObject = file.getAsJsonObject();
                boolean matchesCurrentMcVersion = false;
                for (JsonElement version : fileAsJsonObject.get("versions").getAsJsonArray()) {
                    if (!version.getAsString().equals(mcVersion)) continue;
                    matchesCurrentMcVersion = true;
                }
                if (!matchesCurrentMcVersion) continue;
                String name = fileAsJsonObject.get("display").getAsString();
                String url = fileAsJsonObject.get("url").getAsString();
                String type = fileAsJsonObject.get("type").getAsString();
                String date = fileAsJsonObject.get("uploaded_at").getAsString();
                if (!isIncludeAlphaVersion && type.equals(alphaPostfix)) continue;
                queue.add(new Version(name, url, format.parse(date)));
            }
            if (!queue.isEmpty()) {
                Version version = (Version)queue.poll();
                return version;
            }
        }
        return null;
    }

    public static void startVersionCheck(class_746 player) {
        new Thread(() -> {
            try {
                String lastVersionString;
                ModContainer mod;
                String currentVersion;
                Version lastVersion;
                Optional currentMod = FabricLoader.getInstance().getModContainer("modern_industrialization");
                if (MIConfig.getConfig().newVersionMessage && (lastVersion = VersionEvents.fetchVersion((currentVersion = (mod = (ModContainer)currentMod.get()).getMetadata().getVersion().getFriendlyString()).contains(alphaPostfix))) != null && !(lastVersionString = lastVersion.name.replaceFirst("Modern Industrialization v", "").strip()).equals(currentVersion)) {
                    String url = lastVersion.url;
                    class_2583 styleClick = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_27706(class_124.field_1073).method_27706(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)MIText.ClickUrl.text()));
                    class_310.method_1551().execute(() -> {
                        if (class_310.method_1551().field_1724 == player) {
                            player.method_7353((class_2561)MIText.NewVersion.text(lastVersionString, MIText.CurseForge.text().method_10862(styleClick)), false);
                        }
                    });
                }
            }
            catch (Exception e) {
                ModernIndustrialization.LOGGER.error("Failed to get release information from Curseforge.", (Throwable)e);
            }
        }, "Modern Industrialization Update Checker").start();
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> VersionEvents.startVersionCheck(client.field_1724));
    }

    private record Version(String name, String url, Date date) implements Comparable<Version>
    {
        @Override
        public int compareTo(@NotNull Version o) {
            return o.date.compareTo(this.date);
        }
    }
}

