/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import aztech.modern_industrialization.recipe.json.SmeltingRecipeJson;
import com.google.gson.Gson;
import java.util.function.Consumer;
import net.minecraft.class_2444;

public class SmeltingRecipeBuilder
implements MaterialRecipeBuilder {
    private static final transient Gson GSON = new Gson();
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    private final SmeltingRecipeJson json;

    public static void smeltAndBlast(MaterialBuilder.RecipeContext context, Part inputPart, Part outputPart, double experience) {
        new SmeltingRecipeBuilder(context, inputPart, outputPart, experience, false);
        new SmeltingRecipeBuilder(context, inputPart, outputPart, experience, true);
    }

    public SmeltingRecipeBuilder(MaterialBuilder.RecipeContext context, Part inputPart, Part outputPart, int cookingtime, double experience, boolean blasting) {
        this.recipeId = blasting ? "smelting/" + inputPart.key + "_to_" + outputPart.key + "_blasting" : "smelting/" + inputPart.key + "_to_" + outputPart.key + "_smelting";
        this.context = context;
        if (context.getPart(inputPart) == null || context.getPart(outputPart) == null) {
            this.canceled = true;
            this.json = null;
        } else {
            this.json = new SmeltingRecipeJson(SmeltingRecipeJson.SmeltingRecipeType.ofBlasting(blasting), context.getPart(inputPart).getItemId(), context.getPart(outputPart).getItemId(), cookingtime, experience);
            context.addRecipe(this);
        }
    }

    public SmeltingRecipeBuilder(MaterialBuilder.RecipeContext context, Part partInput, Part partOutput, double experience, boolean blasting) {
        this(context, partInput, partOutput, blasting ? 100 : 200, experience, blasting);
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            this.json.offerTo(consumer, fullId);
        }
    }

    public static class Ingredient {
        String item;
    }
}

