/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.materials.MaterialHardness;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2444;

public class Material {
    public final String name;
    public final MaterialHardness hardness;
    final Map<String, MaterialPart> parts;
    public final Consumer<Consumer<class_2444>> registerRecipes;

    Material(String name, MaterialHardness hardness, Map<String, MaterialPart> parts, Consumer<Consumer<class_2444>> registerRecipes) {
        this.name = name;
        this.hardness = hardness;
        this.parts = parts;
        this.registerRecipes = registerRecipes;
    }

    public Map<String, MaterialPart> getParts() {
        return Collections.unmodifiableMap(this.parts);
    }

    public MaterialPart getPart(Part part) {
        MaterialPart ret = this.parts.get(part.key);
        if (ret == null) {
            throw new IllegalArgumentException("Can't find part " + part + " in material " + this.name);
        }
        return ret;
    }
}

