/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.textures.TextureHelper;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1792;

public class GemPart
extends Part
implements BuildablePart {
    public GemPart() {
        super("gem");
    }

    @Override
    public Part getPart() {
        return MIParts.GEM;
    }

    @Override
    public MaterialPart build(MaterialBuilder.PartContext ctx) {
        return new RegularPart("", "gem").withRegister((partContext, part, itemPath, itemId, itemTag) -> {
            class_1792 item = RegularPart.createSimpleItem(partContext.getEnglishName(), itemPath, partContext, part);
            TagsToGenerate.generateTag("c:" + itemPath, item.method_8389());
        }).withTextureRegister((mtm, partContext, part, itemPath) -> {
            String template = String.format("modern_industrialization:textures/materialsets/gems/%s.png", partContext.getMaterialName());
            try {
                class_1011 image = mtm.getAssetAsTexture(template);
                TextureHelper.colorize(image, partContext.getColoramp());
                String texturePath = String.format("modern_industrialization:textures/item/%s.png", itemPath);
                mtm.addTexture(texturePath, image);
                image.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).withCustomFormattablePath("%s", "%s").build(ctx);
    }
}

