/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.multiblocks.HatchType;

public class HatchFlags {
    private final int flags;

    public HatchFlags(int flags) {
        this.flags = flags;
    }

    public boolean allows(HatchType type) {
        return (this.flags & 1 << type.getId()) > 0;
    }

    public static class Builder {
        private int flags = 0;

        public Builder with(HatchType type) {
            this.flags |= 1 << type.getId();
            return this;
        }

        public Builder with(HatchType ... types) {
            for (HatchType type : types) {
                this.with(type);
            }
            return this;
        }

        public HatchFlags build() {
            return new HatchFlags(this.flags);
        }
    }
}

