/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

public enum MachineTier {
    BRONZE("bronze", true, 2, 2),
    STEEL("steel", true, 4, 4),
    LV("lv", false, 32, 8),
    MULTIBLOCK("multiblock", false, 128, 8),
    UNLIMITED("unlimited", false, Integer.MAX_VALUE, 8);

    private final String name;
    private final boolean steam;
    private final int maxEu;
    private final int baseEu;

    private MachineTier(String name, boolean steam, int maxEu, int baseEu) {
        this.name = name;
        this.steam = steam;
        this.maxEu = maxEu;
        this.baseEu = baseEu;
    }

    public boolean isSteam() {
        return this.steam;
    }

    public boolean isElectric() {
        return !this.steam;
    }

    public int getBaseEu() {
        return this.baseEu;
    }

    public int getMaxEu() {
        return this.maxEu;
    }

    public String toString() {
        return this.name;
    }

    public int getMaxStoredEu() {
        return this.isSteam() ? 0 : this.getMaxEu() * 100;
    }
}

