/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class RecipeEfficiencyBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;

        public Parameters(int renderX, int renderY) {
            this.renderX = renderX;
            this.renderY = renderY;
        }
    }

    private static class Data {
        final boolean hasActiveRecipe;
        final int efficiencyTicks;
        final int maxEfficiencyTicks;
        final long currentRecipeEu;
        final long baseRecipeEu;
        final long maxRecipeEu;

        private Data() {
            this.hasActiveRecipe = false;
            this.efficiencyTicks = 0;
            this.maxEfficiencyTicks = 0;
            this.currentRecipeEu = 0L;
            this.baseRecipeEu = 0L;
            this.maxRecipeEu = 0L;
        }

        private Data(int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu, long maxRecipeEu) {
            this.efficiencyTicks = efficiencyTicks;
            this.maxEfficiencyTicks = maxEfficiencyTicks;
            this.hasActiveRecipe = true;
            this.currentRecipeEu = currentRecipeEu;
            this.baseRecipeEu = baseRecipeEu;
            this.maxRecipeEu = maxRecipeEu;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        final Parameters params;
        boolean hasActiveRecipe;
        int efficiencyTicks;
        int maxEfficiencyTicks;
        long currentRecipeEu;
        long baseRecipeEu;
        long maxRecipeEu;
        private static final class_2960 TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
        private static final int WIDTH = 100;
        private static final int HEIGHT = 2;

        public Client(class_2540 buf) {
            this.params = new Parameters(buf.readInt(), buf.readInt());
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.hasActiveRecipe = buf.readBoolean();
            if (this.hasActiveRecipe) {
                this.efficiencyTicks = buf.readInt();
                this.maxEfficiencyTicks = buf.readInt();
                this.currentRecipeEu = buf.readLong();
                this.baseRecipeEu = buf.readLong();
            }
            this.maxRecipeEu = buf.readLong();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                class_332.method_25291((class_4587)matrices, (int)(x + Client.this.params.renderX - 1), (int)(y + Client.this.params.renderY - 1), (int)helper.method_25305(), (float)0.0f, (float)2.0f, (int)102, (int)4, (int)102, (int)6);
                if (Client.this.hasActiveRecipe) {
                    int barPixels = (int)((float)Client.this.efficiencyTicks / (float)Client.this.maxEfficiencyTicks * 100.0f);
                    class_332.method_25291((class_4587)matrices, (int)(x + Client.this.params.renderX), (int)(y + Client.this.params.renderY), (int)helper.method_25305(), (float)0.0f, (float)0.0f, (int)barPixels, (int)2, (int)102, (int)6);
                }
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(Client.this.params.renderX, Client.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                    ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                    if (Client.this.hasActiveRecipe) {
                        DecimalFormat factorFormat = new DecimalFormat("#.#");
                        tooltip.add(MIText.EfficiencyTicks.text(Client.this.efficiencyTicks, Client.this.maxEfficiencyTicks));
                        tooltip.add(MIText.EfficiencyFactor.text(factorFormat.format((double)Client.this.currentRecipeEu / (double)Client.this.baseRecipeEu)));
                        tooltip.add(MIText.EfficiencyEu.text(Client.this.currentRecipeEu));
                    } else {
                        tooltip.add(MIText.EfficiencyDefaultMessage.text());
                    }
                    tooltip.add(MIText.EfficiencyMaxOverclock.text(Client.this.maxRecipeEu));
                    screen.method_30901(matrices, tooltip, cursorX, cursorY);
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Data> {
        private final Parameters params;
        private final CrafterComponent crafter;

        public Server(Parameters params, CrafterComponent crafter) {
            this.params = params;
            this.crafter = crafter;
        }

        @Override
        public Data copyData() {
            if (this.crafter.hasActiveRecipe()) {
                return new Data(this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu(), this.crafter.getBehavior().getMaxRecipeEu());
            }
            return new Data();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            if (!this.crafter.hasActiveRecipe()) {
                return cachedData.hasActiveRecipe;
            }
            return this.crafter.getEfficiencyTicks() != cachedData.efficiencyTicks || this.crafter.getMaxEfficiencyTicks() != cachedData.maxEfficiencyTicks || this.crafter.getCurrentRecipeEu() != cachedData.currentRecipeEu || this.crafter.getBaseRecipeEu() != cachedData.baseRecipeEu || this.crafter.getBehavior().getMaxRecipeEu() != cachedData.maxRecipeEu;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            if (this.crafter.hasActiveRecipe()) {
                buf.writeBoolean(true);
                buf.writeInt(this.crafter.getEfficiencyTicks());
                buf.writeInt(this.crafter.getMaxEfficiencyTicks());
                buf.writeLong(this.crafter.getCurrentRecipeEu());
                buf.writeLong(this.crafter.getBaseRecipeEu());
            } else {
                buf.writeBoolean(false);
            }
            buf.writeLong(this.crafter.getBehavior().getMaxRecipeEu());
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.RECIPE_EFFICIENCY_BAR;
        }
    }
}

