/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class GunpowderOverclockGui {

    public static class Parameters {
        public final int renderX;
        public final int renderY;

        public Parameters(int renderX, int renderY) {
            this.renderX = renderX;
            this.renderY = renderY;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        final Parameters params;
        int remTick;

        public Client(class_2540 buf) {
            this.params = new Parameters(buf.readInt(), buf.readInt());
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.remTick = buf.readInt();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                if (Client.this.remTick > 0) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                    int px = x + Client.this.params.renderX;
                    int py = y + Client.this.params.renderY;
                    helper.method_25302(matrices, px, py, 0, 58, 20, 20);
                }
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                if (Client.this.remTick > 0 && RenderHelper.isPointWithinRectangle(Client.this.params.renderX, Client.this.params.renderY, 20, 20, cursorX - x, cursorY - y)) {
                    ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                    int seconds = Client.this.remTick / 20;
                    int hours = seconds / 3600;
                    int minutes = seconds % 3600 / 60;
                    String time = String.format("%d", seconds);
                    if (hours > 0) {
                        time = String.format("%d:%02d:%02d", hours, minutes, seconds % 60);
                    } else if (minutes > 0) {
                        time = String.format("%d:%02d", minutes, seconds % 60);
                    }
                    tooltip.add(MIText.GunpowderTime.text(time));
                    screen.method_30901(matrices, tooltip, cursorX, cursorY);
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Integer> {
        public final Parameters params;
        public final Supplier<Integer> remTickSupplier;

        public Server(Parameters params, Supplier<Integer> remTickSupplier) {
            this.params = params;
            this.remTickSupplier = remTickSupplier;
        }

        @Override
        public Integer copyData() {
            return this.remTickSupplier.get();
        }

        @Override
        public boolean needsSync(Integer cachedData) {
            return !cachedData.equals(this.remTickSupplier.get());
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            buf.writeInt(this.remTickSupplier.get().intValue());
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.GUNPOWDER_OVERCLOCK_GUI;
        }
    }
}

