/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class FluidGUIComponent {

    public record Data(FluidVariant fluid, long amount, long capacity) {
    }

    public static class Client
    implements SyncedComponent.Client {
        Data fluidData;

        public Client(class_2540 buf) {
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.fluidData = new Data(FluidVariant.fromPacket((class_2540)buf), buf.readLong(), buf.readLong());
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            private static final int posX = 70;
            private static final int posY = 12;

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                FluidVariant fluid = Client.this.fluidData.fluid;
                float fracFull = (float)Client.this.fluidData.amount / (float)Client.this.fluidData.capacity;
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                helper.method_25302(matrices, x + 70, y + 12, 92, 38, 46, 62);
                if (!fluid.isBlank()) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            float localFullness = Math.min(Math.max(3.0f * fracFull - (float)(2 - j), 0.0f), 1.0f);
                            RenderHelper.drawFluidInGui(matrices, fluid, x + 70 + 7 + i * 16, (float)(y + 12 + 7 + j * 16) + (1.0f - localFullness) * 16.0f, 16, localFullness);
                        }
                    }
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                helper.method_25302(matrices, x + 70 + 7, y + 12 + 7, 60, 38, 32, 48);
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(77, 19, 32, 48, cursorX - x, cursorY - y)) {
                    screen.method_30901(matrices, FluidHelper.getTooltipForFluidStorage(Client.this.fluidData.fluid, Client.this.fluidData.amount, Client.this.fluidData.capacity), cursorX, cursorY);
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Data> {
        public final Supplier<Data> fluidDataSupplier;

        public Server(Supplier<Data> fluidDataSupplier) {
            this.fluidDataSupplier = fluidDataSupplier;
        }

        @Override
        public Data copyData() {
            return this.fluidDataSupplier.get();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            Data newFluidData = this.fluidDataSupplier.get();
            return !cachedData.equals(newFluidData);
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            Data fluidData = this.fluidDataSupplier.get();
            fluidData.fluid.toPacket(buf);
            buf.writeLong(fluidData.amount);
            buf.writeLong(fluidData.capacity);
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.FLUID_STORAGE_GUI;
        }
    }
}

