/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class AutoExtract {

    private static class Data {
        public final boolean extractItems;
        public final boolean extractFluids;

        private Data(boolean extractItems, boolean extractFluids) {
            this.extractItems = extractItems;
            this.extractFluids = extractFluids;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        final boolean displayAsInsert;
        final boolean hasExtractItems;
        final boolean hasExtractFluids;
        boolean[] extractStatus = new boolean[2];

        public Client(class_2540 buf) {
            this.displayAsInsert = buf.readBoolean();
            this.hasExtractItems = buf.readBoolean();
            this.hasExtractFluids = buf.readBoolean();
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.extractStatus[0] = buf.readBoolean();
            this.extractStatus[1] = buf.readBoolean();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        private class Renderer
        implements ClientComponentRenderer {
            private Renderer() {
            }

            @Override
            public void addButtons(ClientComponentRenderer.ButtonContainer container) {
                if (Client.this.hasExtractFluids) {
                    this.addExtractButton(container, false);
                }
                if (Client.this.hasExtractItems) {
                    this.addExtractButton(container, true);
                }
            }

            private void addExtractButton(ClientComponentRenderer.ButtonContainer container, boolean isItem) {
                int u = isItem ? 20 : 0;
                String type = isItem ? "item" : "fluid";
                int index = isItem ? 0 : 1;
                String insertOrExtract = Client.this.displayAsInsert ? "insert" : "extract";
                container.addButton(u, (class_2561)new class_2585(type + " auto-extract"), syncId -> {
                    boolean newExtract;
                    Client.this.extractStatus[index] = newExtract = !Client.this.extractStatus[index];
                    class_2540 buf = PacketByteBufs.create();
                    buf.writeInt(syncId.intValue());
                    buf.writeBoolean(isItem);
                    buf.writeBoolean(newExtract);
                    ClientPlayNetworking.send((class_2960)MachinePackets.C2S.SET_AUTO_EXTRACT, (class_2540)buf);
                }, () -> {
                    ArrayList<class_5250> lines = new ArrayList<class_5250>();
                    if (Client.this.extractStatus[index]) {
                        class_5250 component = isItem ? (Client.this.displayAsInsert ? MIText.ItemAutoInsertOn.text() : MIText.ItemAutoExtractOn.text()) : (Client.this.displayAsInsert ? MIText.FluidAutoInsertOn.text() : MIText.FluidAutoExtractOn.text());
                        lines.add(component);
                        lines.add(MIText.ClickToDisable.text().method_10862(TextHelper.GRAY_TEXT));
                    } else {
                        class_5250 component = isItem ? (Client.this.displayAsInsert ? MIText.ItemAutoInsertOff.text() : MIText.ItemAutoExtractOff.text()) : (Client.this.displayAsInsert ? MIText.FluidAutoInsertOff.text() : MIText.FluidAutoExtractOff.text());
                        lines.add(component);
                        lines.add(MIText.ClickToEnable.text().method_10862(TextHelper.GRAY_TEXT));
                    }
                    return lines;
                }, () -> Client.this.extractStatus[index]);
            }

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Data> {
        private final OrientationComponent orientation;
        private final boolean displayAsInsert;

        public Server(OrientationComponent orientation, boolean displayAsInsert) {
            this.orientation = orientation;
            this.displayAsInsert = displayAsInsert;
        }

        public Server(OrientationComponent orientation) {
            this(orientation, false);
        }

        @Override
        public Data copyData() {
            return new Data(this.orientation.extractItems, this.orientation.extractFluids);
        }

        @Override
        public boolean needsSync(Data cachedData) {
            return cachedData.extractItems != this.orientation.extractItems || cachedData.extractFluids != this.orientation.extractFluids;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeBoolean(this.displayAsInsert);
            buf.writeBoolean(this.orientation.params.hasExtractItems);
            buf.writeBoolean(this.orientation.params.hasExtractFluids);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            buf.writeBoolean(this.orientation.extractItems);
            buf.writeBoolean(this.orientation.extractFluids);
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.AUTO_EXTRACT;
        }

        public OrientationComponent getOrientation() {
            return this.orientation;
        }
    }
}

