/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.IComponent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;

public class IntegerHistoryComponent
implements IComponent {
    protected final Map<String, int[]> histories = new HashMap<String, int[]>();
    protected final Map<String, Integer> updatingValue = new HashMap<String, Integer>();
    public final String[] KEYS;
    public final int TICK_HISTORY_SIZE;

    public IntegerHistoryComponent(String[] keys, int tick_history_size) {
        this.KEYS = keys;
        this.TICK_HISTORY_SIZE = tick_history_size;
        this.clear();
    }

    @Override
    public void writeNbt(class_2487 tag) {
        for (String key : this.KEYS) {
            tag.method_10539(key, this.histories.get(key));
        }
    }

    @Override
    public void readNbt(class_2487 tag) {
        for (String key : this.KEYS) {
            int[] array;
            if (tag.method_10545(key) && (array = tag.method_10561(key)).length == this.TICK_HISTORY_SIZE) {
                this.histories.put(key, array);
                continue;
            }
            this.histories.put(key, new int[this.TICK_HISTORY_SIZE]);
        }
    }

    public double getAverage(String key) {
        int[] values;
        double avg = 0.0;
        for (int value : values = this.histories.get(key)) {
            avg += (double)value;
        }
        return avg / (double)this.TICK_HISTORY_SIZE;
    }

    public void clear() {
        for (String key : this.KEYS) {
            this.histories.put(key, new int[this.TICK_HISTORY_SIZE]);
            this.updatingValue.put(key, 0);
        }
    }

    public void tick() {
        for (String key : this.KEYS) {
            int[] valuesArray = this.histories.get(key);
            int[] newValues = new int[this.TICK_HISTORY_SIZE];
            System.arraycopy(valuesArray, 0, newValues, 1, this.TICK_HISTORY_SIZE - 1);
            newValues[0] = this.updatingValue.get(key);
            this.histories.put(key, newValues);
            this.updatingValue.put(key, 0);
        }
    }

    public void addValue(String key, int delta) {
        if (!this.updatingValue.containsKey(key)) {
            throw new IllegalArgumentException("No key found for : " + key);
        }
        this.updatingValue.put(key, this.updatingValue.get(key) + delta);
    }
}

