/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.TooltipProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class FluidConsumerComponent
implements IComponent.ServerOnly,
TooltipProvider {
    private long euBuffer = 0L;
    private final long maxEuProduction;
    private final Predicate<class_3611> acceptedFluid;
    private final ToLongFunction<class_3611> fluidEUperMb;
    private final boolean fluidFuelsOnly;

    private FluidConsumerComponent(long maxEuProduction, Predicate<class_3611> acceptedFluid, ToLongFunction<class_3611> fluidEUperMb, boolean fluidFuelsOnly) {
        this.fluidFuelsOnly = fluidFuelsOnly;
        this.maxEuProduction = maxEuProduction;
        this.acceptedFluid = acceptedFluid;
        this.fluidEUperMb = fluidEUperMb;
    }

    public static FluidConsumerComponent of(long maxEuProduction, Predicate<class_3611> acceptedFluid, ToLongFunction<class_3611> fluidEUperMb) {
        return new FluidConsumerComponent(maxEuProduction, acceptedFluid, fluidEUperMb, false);
    }

    public static FluidConsumerComponent of(long maxEuProduction, class_3611 acceptedFluid, long fluidEUperMb) {
        return FluidConsumerComponent.of(maxEuProduction, (class_3611 f) -> f == acceptedFluid, f -> fluidEUperMb);
    }

    public static FluidConsumerComponent ofFluidFuels(long maxEuProduction) {
        return new FluidConsumerComponent(maxEuProduction, f -> FluidFuelRegistry.getEu(f) != 0, FluidFuelRegistry::getEu, true);
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("euBuffer", this.euBuffer);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.euBuffer = tag.method_10537("euBuffer");
    }

    public long getEuProduction(List<ConfigurableFluidStack> fluidInputs, long maxEnergyInsertable) {
        long maxEuProduced = Math.min(maxEnergyInsertable, this.maxEuProduction);
        if (maxEuProduced == 0L) {
            return 0L;
        }
        if (this.euBuffer >= maxEuProduced) {
            this.euBuffer -= maxEuProduced;
            return maxEuProduced;
        }
        long euProduced = 0L;
        for (ConfigurableFluidStack stack : fluidInputs) {
            class_3611 fluid = ((FluidVariant)stack.getResource()).getFluid();
            if (!this.acceptedFluid.test(fluid) || stack.getAmount() < 81L) continue;
            long fuelEu = this.fluidEUperMb.applyAsLong(fluid);
            long mbConsumedMax = Math.min((maxEuProduced - euProduced + fuelEu - 1L) / fuelEu, stack.getAmount() / 81L);
            stack.decrement(mbConsumedMax * 81L);
            if ((euProduced += mbConsumedMax * fuelEu) < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        return euProduced;
    }

    @Override
    public List<class_2561> getTooltips() {
        ArrayList<class_2561> returnList = new ArrayList<class_2561>();
        returnList.add(new MITooltips.Line(MIText.MaxEuProduction).arg(this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).build());
        if (this.fluidFuelsOnly) {
            returnList.add(new MITooltips.Line(MIText.AcceptAnyFluidFuels).build());
        } else {
            PriorityQueue<InformationEntry> informationEntries = new PriorityQueue<InformationEntry>();
            for (class_3611 f : class_2378.field_11154) {
                if (!this.acceptedFluid.test(f)) continue;
                informationEntries.add(new InformationEntry(this.fluidEUperMb.applyAsLong(f), f));
            }
            if (informationEntries.size() == 0) {
                throw new IllegalStateException("No fluids accepted for FluidConsumerComponent");
            }
            if (informationEntries.size() == 1) {
                InformationEntry entry = (InformationEntry)informationEntries.poll();
                returnList.add(new MITooltips.Line(MIText.AcceptSingleFluid).arg(entry.fluid).arg(entry.euPerMb, MITooltips.EU_PARSER).build());
            } else {
                returnList.add(new MITooltips.Line(MIText.AcceptFollowingFluid).build());
                for (InformationEntry entry : informationEntries) {
                    returnList.add(new MITooltips.Line(MIText.AcceptFollowingFluidEntry).arg(entry.fluid).arg(entry.euPerMb, MITooltips.EU_PARSER).build());
                }
            }
        }
        return returnList;
    }

    private record InformationEntry(long euPerMb, class_3611 fluid) implements Comparable<InformationEntry>
    {
        @Override
        public int compareTo(@NotNull InformationEntry o) {
            return Long.compare(this.euPerMb, o.euPerMb);
        }
    }
}

