/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.ScrewdriverableBlockEntity;
import aztech.modern_industrialization.compat.megane.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.FluidConsumerComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.TooltipProvider;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class EnergyFromFluidMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
ScrewdriverableBlockEntity,
EnergyListComponentHolder,
TooltipProvider {
    @Nullable
    private ShapeMatcher shapeMatcher = null;
    private boolean allowNormalOperation = false;
    private final ActiveShapeComponent activeShape;
    private final MultiblockInventoryComponent inventory;
    private final IsActiveComponent isActiveComponent;
    private final List<EnergyComponent> energyOutputs = new ArrayList<EnergyComponent>();
    private final FluidConsumerComponent fluidConsumer;

    public EnergyFromFluidMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, FluidConsumerComponent fluidConsumer) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(128).build(), new OrientationComponent.Params(false, false, false));
        this.activeShape = new ActiveShapeComponent(new ShapeTemplate[]{shapeTemplate});
        this.inventory = new MultiblockInventoryComponent();
        this.isActiveComponent = new IsActiveComponent();
        this.fluidConsumer = fluidConsumer;
        this.registerComponents(this.activeShape, this.isActiveComponent, fluidConsumer);
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    @Override
    public List<EnergyComponent> getEnergyComponents() {
        return this.energyOutputs;
    }

    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyOutputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyOutputs(this.energyOutputs);
        }
    }

    @Override
    public boolean useScrewdriver(class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.useScrewdriver(this.activeShape, player, hand, hitResult);
    }

    @Override
    public final MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActiveComponent.isActive);
    }

    @Override
    public final void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            if (this.allowNormalOperation) {
                long euProduced = this.fluidConsumer.getEuProduction(this.inventory.getFluidInputs(), this.insertEnergy(Long.MAX_VALUE, Simulation.SIMULATE));
                this.insertEnergy(euProduced, Simulation.ACT);
                this.isActiveComponent.updateActive(euProduced != 0L, this);
            }
            this.method_5431();
        }
    }

    public long insertEnergy(long value, Simulation simulation) {
        long rem = value;
        long inserted = 0L;
        for (EnergyComponent e : this.energyOutputs) {
            if (rem <= 0L) continue;
            rem -= (inserted += e.insertEu(rem, simulation));
        }
        return inserted;
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.field_11863, this.field_11867, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.field_11863);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.allowNormalOperation = false;
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.field_11863);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.inventory.rebuild(this.shapeMatcher);
                this.onSuccessfulMatch(this.shapeMatcher);
                this.shapeValid.shapeValid = true;
                this.allowNormalOperation = true;
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    protected final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.field_11863);
            this.shapeMatcher = null;
        }
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.fluidConsumer.getTooltips();
    }
}

