/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.compat.megane.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class ElectricCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private final List<EnergyComponent> energyInputs = new ArrayList<EnergyComponent>();
    private final MachineRecipeType recipeType;
    private final UpgradeComponent upgrades;

    public ElectricCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, MachineRecipeType recipeType) {
        super(bep, name, new OrientationComponent.Params(false, false, false), new ShapeTemplate[]{shapeTemplate});
        this.recipeType = recipeType;
        this.upgrades = new UpgradeComponent();
        this.registerComponents(this.upgrades);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    public List<EnergyComponent> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            result = this.upgrades.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        return result;
    }

    @Override
    public List<class_1799> dropExtra() {
        List<class_1799> drops = super.dropExtra();
        drops.add(this.upgrades.getDrop());
        return drops;
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            long total = 0L;
            for (EnergyComponent energyComponent : ElectricCraftingMultiblockBlockEntity.this.energyInputs) {
                total += energyComponent.consumeEu(max - total, simulation);
            }
            return total;
        }

        @Override
        public MachineRecipeType recipeType() {
            return ElectricCraftingMultiblockBlockEntity.this.recipeType;
        }

        @Override
        public long getBaseRecipeEu() {
            return MachineTier.MULTIBLOCK.getBaseEu();
        }

        @Override
        public long getMaxRecipeEu() {
            return (long)MachineTier.MULTIBLOCK.getMaxEu() + ElectricCraftingMultiblockBlockEntity.this.upgrades.getAddMaxEUPerTick();
        }

        @Override
        public class_1937 getCrafterWorld() {
            return ElectricCraftingMultiblockBlockEntity.this.field_11863;
        }

        @Override
        @Nullable
        public UUID getOwnerUuid() {
            return ElectricCraftingMultiblockBlockEntity.this.placedBy.placerId;
        }
    }
}

