/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.megane.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class DistillationTowerBlockEntity
extends AbstractCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private static final ShapeTemplate[] shapeTemplates;
    private final List<EnergyComponent> energyInputs = new ArrayList<EnergyComponent>();
    private final UpgradeComponent upgrades = new UpgradeComponent();

    public DistillationTowerBlockEntity(BEP bep) {
        super(bep, "distillation_tower", new OrientationComponent.Params(false, false, false), shapeTemplates);
        this.registerComponents(this.upgrades);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    public List<EnergyComponent> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            result = this.upgrades.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        return result;
    }

    @Override
    public List<class_1799> dropExtra() {
        List<class_1799> drops = super.dropExtra();
        drops.add(this.upgrades.getDrop());
        return drops;
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : shapeTemplates) {
            ReiMachineRecipes.registerMultiblockShape("distillation_tower", shapeTemplate);
        }
    }

    static {
        int maxHeight = 9;
        shapeTemplates = new ShapeTemplate[maxHeight];
        SimpleMember casing = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("clean_stainless_steel_machine_casing"))).asBlock());
        SimpleMember pipe = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("stainless_steel_machine_casing_pipe"))).asBlock());
        HatchFlags bottom = new HatchFlags.Builder().with(HatchType.ENERGY_INPUT, HatchType.FLUID_INPUT).build();
        HatchFlags layer = new HatchFlags.Builder().with(HatchType.FLUID_OUTPUT).build();
        for (int i = 0; i < maxHeight; ++i) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.CLEAN_STAINLESS_STEEL);
            for (int y = 0; y <= i + 1; ++y) {
                builder.add3by3(y, casing, y != 0, y == 0 ? bottom : layer);
                if (y == 0) continue;
                builder.add(0, y, 1, pipe, null);
            }
            DistillationTowerBlockEntity.shapeTemplates[i] = builder.build();
        }
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            long total = 0L;
            for (EnergyComponent energyComponent : DistillationTowerBlockEntity.this.energyInputs) {
                total += energyComponent.consumeEu(max - total, simulation);
            }
            return total;
        }

        @Override
        public MachineRecipeType recipeType() {
            return MIMachineRecipeTypes.DISTILLATION_TOWER;
        }

        @Override
        public long getBaseRecipeEu() {
            return MachineTier.MULTIBLOCK.getBaseEu();
        }

        @Override
        public long getMaxRecipeEu() {
            return (long)MachineTier.MULTIBLOCK.getMaxEu() + DistillationTowerBlockEntity.this.upgrades.getAddMaxEUPerTick();
        }

        @Override
        public class_1937 getCrafterWorld() {
            return DistillationTowerBlockEntity.this.field_11863;
        }

        @Override
        public int getMaxFluidOutputs() {
            return DistillationTowerBlockEntity.this.activeShape.getActiveShapeIndex() + 1;
        }

        @Override
        @Nullable
        public UUID getOwnerUuid() {
            return DistillationTowerBlockEntity.this.placedBy.placerId;
        }
    }
}

