/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.NeutronHistoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import aztech.modern_industrialization.machines.components.sync.TemperatureBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearGrid;
import aztech.modern_industrialization.nuclear.INuclearTile;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2591;

public class NuclearHatch
extends HatchBlockEntity
implements INuclearTile {
    private final MIInventory inventory;
    public final NeutronHistoryComponent neutronHistory;
    public final TemperatureComponent nuclearReactorComponent;
    public final boolean isFluid;
    public static final long capacity = 5184000L;

    public NuclearHatch(BEP bep, boolean isFluid) {
        super(bep, new MachineGuiParameters.Builder(isFluid ? "nuclear_fluid_hatch" : "nuclear_item_hatch", true).build(), new OrientationComponent.Params(false, false, false));
        this.isFluid = isFluid;
        SlotPositions slotPos = new SlotPositions.Builder().addSlot(68, 31).addSlots(98, 22, 2, 1).build();
        if (!isFluid) {
            ArrayList<ConfigurableItemStack> itemStack = new ArrayList<ConfigurableItemStack>();
            itemStack.add(ConfigurableItemStack.standardInputSlot());
            itemStack.add(ConfigurableItemStack.standardOutputSlot());
            itemStack.add(ConfigurableItemStack.standardOutputSlot());
            this.inventory = new MIInventory(itemStack, Collections.emptyList(), slotPos, SlotPositions.empty());
            this.nuclearReactorComponent = new TemperatureComponent(3250.0);
        } else {
            ArrayList<ConfigurableFluidStack> fluidStack = new ArrayList<ConfigurableFluidStack>();
            fluidStack.add(ConfigurableFluidStack.standardInputSlot(5184000L));
            fluidStack.add(ConfigurableFluidStack.standardOutputSlot(5184000L));
            fluidStack.add(ConfigurableFluidStack.standardOutputSlot(5184000L));
            this.inventory = new MIInventory(Collections.emptyList(), fluidStack, SlotPositions.empty(), slotPos);
            this.nuclearReactorComponent = new SteamHeaterComponent(3250.0, 8192L, 64L, true, true);
        }
        this.neutronHistory = new NeutronHistoryComponent();
        this.registerComponents(this.inventory, this.nuclearReactorComponent, this.neutronHistory);
        TemperatureBar.Parameters temperatureParams = new TemperatureBar.Parameters(43, 63, 3250);
        this.registerClientComponent(new TemperatureBar.Server(temperatureParams, () -> (int)this.nuclearReactorComponent.getTemperature()));
    }

    @Override
    public HatchType getHatchType() {
        return this.isFluid ? HatchType.NUCLEAR_FLUID : HatchType.NUCLEAR_ITEM;
    }

    @Override
    public boolean upgradesToSteel() {
        return false;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public final void tick() {
        super.tick();
        this.clearMachineLock();
        if (this.isFluid) {
            this.fluidNeutronProductTick(1, true);
        } else {
            NuclearAbsorbable abs;
            class_1792 class_17922;
            ItemVariant itemVariant = (ItemVariant)this.getVariant();
            if (!itemVariant.isBlank() && (class_17922 = itemVariant.getItem()) instanceof NuclearAbsorbable && (abs = (NuclearAbsorbable)class_17922).getNeutronProduct() != null) {
                try (Transaction tx = Transaction.openOuter();){
                    this.inventory.itemStorage.insert((ItemVariant)abs.getNeutronProduct(), abs.getNeutronProductAmount(), (TransactionContext)tx, AbstractConfigurableStack::canPipesExtract, true);
                    tx.abort();
                }
            }
        }
    }

    @Override
    public double getTemperature() {
        return this.nuclearReactorComponent.getTemperature();
    }

    @Override
    public double getHeatTransferCoeff() {
        return 0.01 + (this.getComponent().isPresent() ? ((INuclearComponent)this.getComponent().get()).getHeatConduction() : 0.0);
    }

    @Override
    public double getMeanNeutronAbsorption(NeutronType type) {
        return this.neutronHistory.getAverageReceived(type);
    }

    @Override
    public double getMeanNeutronFlux(NeutronType type) {
        return this.neutronHistory.getAverageFlux(type);
    }

    @Override
    public double getMeanNeutronGeneration() {
        return this.neutronHistory.getAverageGeneration();
    }

    @Override
    public double getMeanEuGeneration() {
        return this.neutronHistory.getAverageEuGeneration();
    }

    @Override
    public TransferVariant getVariant() {
        if (this.isFluid) {
            return this.inventory.getFluidStacks().get(0).getResource();
        }
        return this.inventory.getItemStacks().get(0).getResource();
    }

    @Override
    public long getVariantAmount() {
        if (this.isFluid) {
            return this.inventory.getFluidStacks().get(0).getAmount();
        }
        return this.inventory.getItemStacks().get(0).getAmount();
    }

    @Override
    public boolean isFluid() {
        return this.isFluid;
    }

    @Override
    public void setTemperature(double temp) {
        this.nuclearReactorComponent.setTemperature(temp);
    }

    @Override
    public void putHeat(double eu) {
        Preconditions.checkArgument((eu >= 0.0 ? 1 : 0) != 0);
        this.setTemperature(this.getTemperature() + eu / 64.0);
        this.neutronHistory.addValue("euGeneration", (int)eu);
    }

    @Override
    public int neutronGenerationTick(INuclearGrid grid) {
        double meanNeutron = this.getMeanNeutronAbsorption(NeutronType.BOTH);
        int neutronsProduced = 0;
        if (!this.isFluid) {
            class_1792 class_17922;
            ItemVariant itemVariant = (ItemVariant)this.getVariant();
            if (!itemVariant.isBlank() && (class_17922 = itemVariant.getItem()) instanceof NuclearAbsorbable) {
                NuclearAbsorbable abs = (NuclearAbsorbable)class_17922;
                if (itemVariant.getItem() instanceof NuclearFuel) {
                    meanNeutron += 0.1;
                }
                class_1799 stack = itemVariant.toStack((int)this.getVariantAmount());
                Random rand = this.field_11863.method_8409();
                if (abs instanceof NuclearFuel) {
                    NuclearFuel fuel = (NuclearFuel)abs;
                    neutronsProduced = fuel.simulateDesintegration(meanNeutron, stack, this.nuclearReactorComponent.getTemperature(), rand, grid);
                } else {
                    abs.simulateAbsorption(meanNeutron, stack, rand);
                }
                if (abs.getRemainingDesintegrations(stack) == 0) {
                    try (Transaction tx = Transaction.openOuter();){
                        ConfigurableItemStack absStack = this.inventory.getItemStacks().get(0);
                        absStack.updateSnapshots((TransactionContext)tx);
                        absStack.setAmount(0L);
                        absStack.setKey(ItemVariant.blank());
                        if (abs.getNeutronProduct() != null) {
                            long inserted = this.inventory.itemStorage.insert((ItemVariant)abs.getNeutronProduct(), abs.getNeutronProductAmount(), (TransactionContext)tx, AbstractConfigurableStack::canPipesExtract, true);
                            if (inserted == abs.getNeutronProductAmount()) {
                                tx.commit();
                            }
                            tx.abort();
                        }
                        tx.commit();
                    }
                } else {
                    this.getInventory().getItemStacks().get(0).setKey(ItemVariant.of((class_1799)stack));
                }
            }
            this.neutronHistory.addValue("neutronGeneration", neutronsProduced);
            return neutronsProduced;
        }
        return 0;
    }

    private static int randIntFromDouble(double value, Random rand) {
        return (int)Math.floor(value) + (rand.nextDouble() < value % 1.0 ? 1 : 0);
    }

    public void fluidNeutronProductTick(int neutron, boolean simul) {
        Optional maybeComponent;
        if (this.isFluid && (maybeComponent = this.getComponent()).isPresent()) {
            INuclearComponent component = (INuclearComponent)maybeComponent.get();
            int actualRecipe = NuclearHatch.randIntFromDouble((double)neutron * component.getNeutronProductProbability(), this.method_10997().method_8409());
            if (simul) {
                actualRecipe = neutron;
            }
            if (simul || actualRecipe > 0) {
                try (Transaction tx = Transaction.openOuter();){
                    long extracted = this.inventory.fluidStorage.extractAllSlot((FluidVariant)component.getVariant(), actualRecipe, (TransactionContext)tx, AbstractConfigurableStack::canPipesInsert);
                    this.inventory.fluidStorage.insert((FluidVariant)component.getNeutronProduct(), extracted * component.getNeutronProductAmount(), (TransactionContext)tx, AbstractConfigurableStack::canPipesExtract, true);
                    if (!simul) {
                        tx.commit();
                    }
                }
            }
        }
    }

    private void checkComponentMaxTemperature() {
        if (!this.isFluid) {
            this.getComponent().ifPresent(component -> {
                if ((double)component.getMaxTemperature() < this.getTemperature()) {
                    this.inventory.getItemStacks().get(0).empty();
                }
            });
        }
    }

    @Override
    public void nuclearTick(INuclearGrid grid) {
        this.neutronHistory.tick();
        this.fluidNeutronProductTick(NuclearHatch.randIntFromDouble(this.neutronHistory.getAverageReceived(NeutronType.BOTH), this.method_10997().method_8409()), false);
        if (this.isFluid) {
            double euProduced = ((SteamHeaterComponent)this.nuclearReactorComponent).tick(Collections.singletonList(this.inventory.getFluidStacks().get(0)), this.inventory.getFluidStacks().stream().filter(AbstractConfigurableStack::canPipesExtract).collect(Collectors.toList()));
            grid.registerEuProduction(euProduced);
        }
        this.checkComponentMaxTemperature();
    }

    @Override
    public void absorbNeutrons(int neutronNumber, NeutronType type) {
        Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
        if (type == NeutronType.FAST) {
            this.neutronHistory.addValue("fastNeutronReceived", neutronNumber);
        } else {
            this.neutronHistory.addValue("thermalNeutronReceived", neutronNumber);
        }
    }

    @Override
    public void addNeutronsToFlux(int neutronNumber, NeutronType type) {
        Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
        if (type == NeutronType.FAST) {
            this.neutronHistory.addValue("fastNeutronFlux", neutronNumber);
        } else {
            this.neutronHistory.addValue("thermalNeutronFlux", neutronNumber);
        }
    }

    public static void registerItemApi(class_2591<?> bet) {
        ItemStorage.SIDED.registerForBlockEntities((be, direction) -> direction == class_2350.field_11036 ? ((NuclearHatch)be).getInventory().itemStorage : null, new class_2591[]{bet});
    }

    public static void registerFluidApi(class_2591<?> bet) {
        FluidStorage.SIDED.registerForBlockEntities((be, direction) -> direction == class_2350.field_11036 ? ((NuclearHatch)be).getInventory().fluidStorage : null, new class_2591[]{bet});
    }
}

