/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.compat.megane.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.FluidConsumerComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.TooltipProvider;
import aztech.modern_industrialization.machines.components.sync.EnergyBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_3611;

public class EnergyFromFluidMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder,
TooltipProvider {
    private final CableTier outputTier;
    private final EnergyExtractable extractable;
    protected final MIInventory inventory;
    protected EnergyComponent energy;
    protected IsActiveComponent isActiveComponent;
    protected FluidConsumerComponent fluidConsumer;

    private EnergyFromFluidMachineBlockEntity(BEP bep, String name, CableTier outputTier, long energyCapacity, long fluidCapacity, FluidConsumerComponent fluidConsumer, class_3611 locked, boolean lockButton) {
        super(bep, new MachineGuiParameters.Builder(name, lockButton).build(), new OrientationComponent.Params(true, false, false));
        this.outputTier = outputTier;
        this.energy = new EnergyComponent(energyCapacity);
        this.extractable = this.energy.buildExtractable(tier -> tier == outputTier);
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        this.registerClientComponent(new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity));
        this.isActiveComponent = new IsActiveComponent();
        ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
        SlotPositions itemPositions = SlotPositions.empty();
        List<ConfigurableFluidStack> fluidStacks = locked == null ? Collections.singletonList(ConfigurableFluidStack.standardInputSlot(81L * fluidCapacity)) : Collections.singletonList(ConfigurableFluidStack.lockedInputSlot(81L * fluidCapacity, locked));
        this.fluidConsumer = fluidConsumer;
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(25, 38).build();
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.registerComponents(this.energy, this.isActiveComponent, this.inventory, fluidConsumer);
    }

    public EnergyFromFluidMachineBlockEntity(BEP bep, String name, CableTier outputTier, long energyCapacity, long fluidCapacity, FluidConsumerComponent fluidConsumer) {
        this(bep, name, outputTier, energyCapacity, fluidCapacity, fluidConsumer, null, true);
    }

    public EnergyFromFluidMachineBlockEntity(BEP bep, String name, CableTier outputTier, long energyCapacity, long fluidCapacity, long maxEnergyOutput, class_3611 acceptedFluid, long fluidEUperMb) {
        this(bep, name, outputTier, energyCapacity, fluidCapacity, FluidConsumerComponent.of(maxEnergyOutput, acceptedFluid, fluidEUperMb), acceptedFluid, false);
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        ConfigurableFluidStack stack = this.inventory.getFluidStacks().get(0);
        long euProduced = this.fluidConsumer.getEuProduction(Collections.singletonList(stack), this.energy.getRemainingCapacity());
        this.energy.insertEu(euProduced, Simulation.ACT);
        this.isActiveComponent.updateActive(0L != euProduced, this);
        EnergyHelper.autoOuput(this, this.orientation, this.outputTier, this.energy);
        this.method_5431();
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.MOVEABLE.registerForBlockEntities((be, direction) -> {
            EnergyFromFluidMachineBlockEntity abe = (EnergyFromFluidMachineBlockEntity)be;
            if (abe.orientation.outputDirection == direction) {
                return abe.extractable;
            }
            return null;
        }, new class_2591[]{bet});
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.fluidConsumer.getTooltips();
    }
}

