/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.inventory.SlotConfig;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.StorageUtil2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public final class MIInventory
implements IComponent {
    public static final MIInventory EMPTY = new MIInventory(Collections.emptyList(), Collections.emptyList(), SlotPositions.empty(), SlotPositions.empty());
    public final MIItemStorage itemStorage;
    public final MIFluidStorage fluidStorage;
    public final SlotPositions itemPositions;
    public final SlotPositions fluidPositions;

    public MIInventory(List<ConfigurableItemStack> itemStacks, List<ConfigurableFluidStack> fluidStacks, SlotPositions itemPositions, SlotPositions fluidPositions) {
        this.itemStorage = new MIItemStorage(new ArrayList<ConfigurableItemStack>(itemStacks));
        this.fluidStorage = new MIFluidStorage(new ArrayList<ConfigurableFluidStack>(fluidStacks));
        this.itemPositions = itemPositions;
        this.fluidPositions = fluidPositions;
        if (itemPositions.size() != itemStacks.size()) {
            throw new IllegalArgumentException("Mismatched item slots and positions. Slot count: " + itemStacks.size() + ", position count: " + itemPositions.size());
        }
        if (fluidPositions.size() != fluidStacks.size()) {
            throw new IllegalArgumentException("Mismatched fluid slots and positions. Slot count: " + fluidStacks.size() + ", position count: " + fluidPositions.size());
        }
    }

    public List<ConfigurableItemStack> getItemStacks() {
        return this.itemStorage.stacks;
    }

    public List<ConfigurableFluidStack> getFluidStacks() {
        return this.fluidStorage.stacks;
    }

    public void autoExtractItems(class_1937 world, class_2338 pos, class_2350 direction) {
        Storage<ItemVariant> target = (Storage<ItemVariant>)ItemStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
        if ((target = StorageUtil2.wrapInventory(target)) != null) {
            StorageUtil.move((Storage)this.itemStorage, target, k -> true, (long)Long.MAX_VALUE, null);
        }
    }

    public void autoExtractFluids(class_1937 world, class_2338 pos, class_2350 direction) {
        Storage target = (Storage)FluidStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
        if (target != null) {
            StorageUtil.move((Storage)this.fluidStorage, (Storage)target, k -> true, (long)Long.MAX_VALUE, null);
        }
    }

    public void autoInsertItems(class_1937 world, class_2338 pos, class_2350 direction) {
        Storage target = (Storage)ItemStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
        if (target != null) {
            StorageUtil.move((Storage)target, (Storage)this.itemStorage, k -> true, (long)Long.MAX_VALUE, null);
        }
    }

    public void autoInsertFluids(class_1937 world, class_2338 pos, class_2350 direction) {
        Storage target = (Storage)FluidStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
        if (target != null) {
            StorageUtil.move((Storage)target, (Storage)this.fluidStorage, k -> true, (long)Long.MAX_VALUE, null);
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        NbtHelper.putList(tag, "items", this.itemStorage.stacks, ConfigurableItemStack::toNbt);
        NbtHelper.putList(tag, "fluids", this.fluidStorage.stacks, ConfigurableFluidStack::toNbt);
    }

    @Override
    public void readNbt(class_2487 tag) {
        ArrayList newItemStacks = new ArrayList();
        ArrayList newFluidStacks = new ArrayList();
        NbtHelper.getList(tag, "items", newItemStacks, ConfigurableItemStack::new);
        NbtHelper.getList(tag, "fluids", newFluidStacks, ConfigurableFluidStack::new);
        SlotConfig.readSlotList(this.itemStorage.stacks, newItemStacks);
        SlotConfig.readSlotList(this.fluidStorage.stacks, newFluidStacks);
    }
}

