/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.nuclear;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionCategory;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionDisplay;
import aztech.modern_industrialization.compat.rei.nuclear.ThermalInteractionCategory;
import aztech.modern_industrialization.compat.rei.nuclear.ThermalInteractionDisplay;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class NeutronInteractionPlugin
implements REIClientPlugin {
    static final CategoryIdentifier<NeutronInteractionDisplay> NEUTRON_CATEGORY = CategoryIdentifier.of((class_2960)new MIIdentifier("neutron_interaction"));
    static final CategoryIdentifier<ThermalInteractionDisplay> THERMAL_CATEGORY = CategoryIdentifier.of((class_2960)new MIIdentifier("thermal_interaction"));

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new NeutronInteractionCategory());
        registry.addWorkstations(NEUTRON_CATEGORY, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("nuclear_reactor"))))});
        registry.removePlusButton(NEUTRON_CATEGORY);
        registry.add((DisplayCategory)new ThermalInteractionCategory());
        registry.addWorkstations(THERMAL_CATEGORY, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("nuclear_reactor"))))});
        registry.removePlusButton(THERMAL_CATEGORY);
    }

    public void registerDisplays(DisplayRegistry registry) {
        class_2378.field_11142.method_10220().filter(item -> item instanceof NuclearComponentItem).forEach(item -> {
            ItemVariant product;
            NuclearComponentItem component = (NuclearComponentItem)item;
            if (component.neutronBehaviour != INeutronBehaviour.NO_INTERACTION) {
                registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.FAST_NEUTRON_INTERACTION));
                registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.THERMAL_NEUTRON_INTERACTION));
            }
            registry.add((Display)new ThermalInteractionDisplay(component, ThermalInteractionDisplay.CategoryType.THERMAL_PROPERTIES));
            if (item instanceof NuclearFuel) {
                registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.FISSION));
                registry.add((Display)new ThermalInteractionDisplay(component, ThermalInteractionDisplay.CategoryType.NEUTRON_EFFICIENCY));
            }
            if ((product = (ItemVariant)component.getNeutronProduct()) != null) {
                registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.NEUTRON_PRODUCT));
            }
        });
        for (class_3611 fluid : class_2378.field_11154) {
            FluidVariant variant;
            INuclearComponent component;
            if (!fluid.method_15793(fluid.method_15785()) || fluid == class_3612.field_15906 || (component = INuclearComponent.of(variant = FluidVariant.of((class_3611)fluid))) == null) continue;
            registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.FAST_NEUTRON_INTERACTION));
            registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.THERMAL_NEUTRON_INTERACTION));
            registry.add((Display)new ThermalInteractionDisplay(component, ThermalInteractionDisplay.CategoryType.THERMAL_PROPERTIES));
            if (component.getVariant() == null) continue;
            registry.add((Display)new NeutronInteractionDisplay(component, NeutronInteractionDisplay.CategoryType.NEUTRON_PRODUCT));
        }
        for (final String s : new String[]{"item", "fluid"}) {
            registry.add((Display)new ThermalInteractionDisplay(new INuclearComponent<ItemVariant>(){

                @Override
                public double getHeatConduction() {
                    return 0.01;
                }

                @Override
                public INeutronBehaviour getNeutronBehaviour() {
                    return null;
                }

                @Override
                public int getMaxTemperature() {
                    return 3250;
                }

                @Override
                public ItemVariant getVariant() {
                    return ItemVariant.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(String.format("nuclear_%s_hatch", s)))));
                }
            }, ThermalInteractionDisplay.CategoryType.THERMAL_PROPERTIES));
        }
    }
}

