/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.compat.rei.ReiUtil;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.util.FluidHelper;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class MachineRecipeDisplay
implements Display {
    final MachineRecipe recipe;
    private final class_2960 category;
    private static final BiFunction<EntryStack<?>, Tooltip, Tooltip> FLUID_TOOLTIP = (stack, tooltip) -> {
        FluidStack fs = (FluidStack)stack.castValue();
        long amount = ((FluidStack)stack.cast().getValue()).getAmount();
        return Tooltip.create((class_2561[])new class_2561[]{FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fs.getFluid())), FluidHelper.getFluidAmount(amount)});
    };

    public MachineRecipeDisplay(class_2960 categoryId, MachineRecipe recipe) {
        this.recipe = recipe;
        this.category = categoryId;
    }

    public Stream<EntryIngredient> getItemInputs() {
        return this.recipe.itemInputs.stream().map(i -> ReiUtil.createInputEntries(i).map(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, ReiUtil.getProbabilitySetting(i.probability, true))));
    }

    public Stream<EntryIngredient> getFluidInputs() {
        return this.recipe.fluidInputs.stream().map(i -> EntryIngredient.of(ReiUtil.createFluidEntryStack(i.fluid, i.amount, i.probability, true)));
    }

    public List<EntryIngredient> getInputEntries() {
        return Stream.concat(this.getItemInputs(), this.getFluidInputs()).collect(Collectors.toList());
    }

    public Stream<EntryIngredient> getItemOutputs() {
        return this.recipe.itemOutputs.stream().map(i -> EntryIngredient.of(ReiUtil.createItemEntryStack(i.item, i.amount, i.probability, false)));
    }

    public Stream<EntryIngredient> getFluidOutputs() {
        return this.recipe.fluidOutputs.stream().map(i -> EntryIngredient.of(ReiUtil.createFluidEntryStack(i.fluid, i.amount, i.probability, false)));
    }

    public List<EntryIngredient> getOutputEntries() {
        return Stream.concat(this.getItemOutputs(), this.getFluidOutputs()).collect(Collectors.toList());
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)this.category);
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.of(this.recipe.method_8114());
    }

    public double getSeconds() {
        return (double)this.recipe.duration / 20.0;
    }

    public int getEu() {
        return this.recipe.eu;
    }

    public int getTicks() {
        return this.recipe.duration;
    }
}

