/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.TextHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

public class ReiUtil {
    private static final DecimalFormat PROBABILITY_FORMAT = new DecimalFormat("#.#");

    private ReiUtil() {
    }

    public static EntryIngredient createInputEntries(MachineRecipe.ItemInput input) {
        return EntryIngredient.of(input.getInputItems().stream().map(i -> EntryStacks.of((class_1799)new class_1799((class_1935)i, input.amount))).toList());
    }

    public static EntryStack<?> createItemEntryStack(class_1792 item, int amount, float probability, boolean input) {
        return EntryStacks.of((class_1799)new class_1799((class_1935)item, amount)).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, ReiUtil.getProbabilitySetting(probability, input));
    }

    public static EntryStack<?> createFluidEntryStack(class_3611 fluid, long amount, float probability, boolean input) {
        class_2561 probabilityText = ReiUtil.getProbabilityTooltip(probability, input);
        return EntryStacks.of((class_3611)fluid, (long)amount).setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (stack, oldTooltip) -> {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid)));
            tooltip.add(FluidHelper.getFluidAmount(amount));
            if (probabilityText != null) {
                tooltip.add(probabilityText);
            }
            return Tooltip.create(tooltip);
        });
    }

    @Nullable
    public static class_2561 getProbabilityTooltip(float probability, boolean input) {
        if (probability == 1.0f) {
            return null;
        }
        class_5250 text = probability == 0.0f ? MIText.NotConsumed.text() : (input ? MIText.ChanceConsumption.text(PROBABILITY_FORMAT.format(probability * 100.0f)) : MIText.ChanceProduction.text(PROBABILITY_FORMAT.format(probability * 100.0f)));
        text.method_10862(TextHelper.YELLOW);
        return text;
    }

    public static Function<EntryStack<?>, List<class_2561>> getProbabilitySetting(float probability, boolean input) {
        class_2561 tooltip = ReiUtil.getProbabilityTooltip(probability, input);
        return es -> tooltip == null ? List.of() : List.of(tooltip);
    }

    public static EntryStack<?> createFluidEntryStack(class_3611 fluid) {
        return EntryStacks.of((class_3611)fluid, (long)81000L).setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (stack, oldTooltip) -> {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            tooltip.add(FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid)));
            return Tooltip.create(tooltip);
        });
    }
}

