/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.util.ListJS;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class MIKubeJSPlugin
extends KubeJSPlugin {
    public void addRecipes(RegisterRecipeHandlersEvent event) {
        for (MachineRecipeType mrt : MIMachineRecipeTypes.getRecipeTypes()) {
            event.register(mrt.getId(), MachineRecipe::new);
        }
    }

    private static class MachineRecipe
    extends RecipeJS {
        private float[] itemInputProbabilities;
        private float[] itemOutputProbabilities;

        private MachineRecipe() {
        }

        public void create(@NotNull ListJS listJS) {
            throw new RecipeExceptionJS("MachineRecipe#create should never be called");
        }

        public void deserialize() {
            JsonElement o;
            JsonElement j = this.json.get("item_inputs");
            if (j != null) {
                if (j.isJsonArray()) {
                    JsonArray arr = j.getAsJsonArray();
                    this.itemInputProbabilities = new float[arr.size()];
                    for (int i = 0; i < arr.size(); ++i) {
                        this.readItemInput(arr.get(i), i);
                    }
                } else {
                    this.itemInputProbabilities = new float[1];
                    this.readItemInput(j, 0);
                }
            }
            if ((o = this.json.get("item_outputs")) != null) {
                if (o.isJsonArray()) {
                    JsonArray arr = o.getAsJsonArray();
                    this.itemOutputProbabilities = new float[arr.size()];
                    for (int i = 0; i < arr.size(); ++i) {
                        this.readItemOutput(arr.get(i), i);
                    }
                } else {
                    this.itemOutputProbabilities = new float[1];
                    this.readItemOutput(o, 0);
                }
            }
            if (this.json.has("id")) {
                this.id = new class_2960(this.json.get("id").getAsString());
            }
        }

        private void readItemInput(JsonElement el, int index) {
            JsonObject obj = el.getAsJsonObject();
            int amount = 1;
            if (obj.has("amount")) {
                amount = obj.get("amount").getAsInt();
            }
            if (obj.has("count")) {
                amount = obj.get("count").getAsInt();
            }
            IngredientJS ing = IngredientJS.of((Object)obj);
            ing = ing.withCount(amount);
            this.inputItems.add(ing);
            this.itemInputProbabilities[index] = this.readProbability(obj);
        }

        private void readItemOutput(JsonElement el, int index) {
            JsonObject obj = el.getAsJsonObject();
            ItemStackJS stack = ItemStackJS.resultFromRecipeJson((JsonElement)obj);
            if (obj.has("amount")) {
                stack.setCount(obj.get("amount").getAsInt());
            } else {
                stack.setCount(1);
            }
            this.outputItems.add(stack);
            this.itemOutputProbabilities[index] = this.readProbability(obj);
        }

        private float readProbability(JsonObject o) {
            if (o.has("probability")) {
                return o.get("probability").getAsFloat();
            }
            return 1.0f;
        }

        public void serialize() {
            JsonObject o;
            int i;
            if (this.inputItems.size() > 0) {
                JsonArray itemInputs = new JsonArray();
                for (i = 0; i < this.inputItems.size(); ++i) {
                    IngredientStackJS ingredient = ((IngredientJS)this.inputItems.get(i)).asIngredientStack();
                    o = (JsonObject)ingredient.toJson();
                    o.addProperty("probability", (Number)Float.valueOf(this.itemInputProbabilities[i]));
                    itemInputs.add((JsonElement)o);
                }
                this.json.add("item_inputs", (JsonElement)itemInputs);
            }
            if (this.outputItems.size() > 0) {
                JsonArray itemOutputs = new JsonArray();
                for (i = 0; i < this.outputItems.size(); ++i) {
                    ItemStackJS stack = (ItemStackJS)this.outputItems.get(i);
                    o = new JsonObject();
                    o.addProperty("probability", (Number)Float.valueOf(this.itemOutputProbabilities[i]));
                    o.addProperty("item", stack.getId());
                    o.addProperty("amount", (Number)stack.getCount());
                    itemOutputs.add((JsonElement)o);
                }
                this.json.add("item_outputs", (JsonElement)itemOutputs);
            }
        }

        public JsonElement serializeIngredientStack(IngredientStackJS in) {
            JsonObject json = new JsonObject();
            json.add(in.ingredientKey, in.ingredient.toJson());
            json.addProperty(in.countKey, (Number)in.getCount());
            return json;
        }
    }
}

