/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.api.energy.EnergyMoveable;
import aztech.modern_industrialization.compat.ae2.P2PModels;
import aztech.modern_industrialization.util.Simulation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_156;

public class EnergyP2PTunnelPart
extends CapabilityP2PTunnelPart<EnergyP2PTunnelPart, EnergyMoveable> {
    private static final P2PModels MODELS = new P2PModels("part/energy_p2p_tunnel");
    private static final MethodHandle GET = (MethodHandle)class_156.method_656(() -> {
        try {
            Method get = CapabilityP2PTunnelPart.CapabilityGuard.class.getDeclaredMethod("get", new Class[0]);
            get.setAccessible(true);
            return MethodHandles.lookup().unreflect(get);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    });

    public EnergyP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, EnergyApi.MOVEABLE);
        this.inputHandler = new InputEnergyStorage();
        this.outputHandler = new OutputEnergyStorage();
        this.emptyHandler = new EnergyMoveable(){};
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private EnergyMoveable get(CapabilityP2PTunnelPart.CapabilityGuard guard) {
        try {
            return (EnergyMoveable)GET.invokeExact(guard);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private class InputEnergyStorage
    implements EnergyInsertable {
        private InputEnergyStorage() {
        }

        @Override
        public long insertEnergy(long amount, Simulation simulation) {
            StoragePreconditions.notNegative((long)amount);
            long total = 0L;
            int outputTunnels = EnergyP2PTunnelPart.this.getOutputs().size();
            if (outputTunnels == 0 || amount == 0L) {
                return 0L;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (EnergyP2PTunnelPart target : EnergyP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    EnergyMoveable energyMoveable = EnergyP2PTunnelPart.this.get(capabilityGuard);
                    if (!(energyMoveable instanceof EnergyInsertable)) continue;
                    EnergyInsertable insertable = (EnergyInsertable)energyMoveable;
                    long toSend = amountPerOutput + overflow;
                    long received = insertable.insertEnergy(toSend, simulation);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            try (Transaction tx = Transaction.openOuter();){
                EnergyP2PTunnelPart.this.queueTunnelDrain(PowerUnits.TR, total, (TransactionContext)tx);
                if (simulation.isActing()) {
                    tx.commit();
                }
            }
            return total;
        }

        @Override
        public boolean canInsert(CableTier tier) {
            return tier == CableTier.SUPERCONDUCTOR;
        }
    }

    private class OutputEnergyStorage
    implements EnergyExtractable {
        private OutputEnergyStorage() {
        }

        @Override
        public long extractEnergy(long maxAmount, Simulation simulation) {
            block13: {
                try (CapabilityP2PTunnelPart.CapabilityGuard input = EnergyP2PTunnelPart.this.getInputCapability();){
                    EnergyMoveable energyMoveable = EnergyP2PTunnelPart.this.get(input);
                    if (!(energyMoveable instanceof EnergyExtractable)) break block13;
                    EnergyExtractable extractable = (EnergyExtractable)energyMoveable;
                    long extracted = extractable.extractEnergy(maxAmount, simulation);
                    try (Transaction tx = Transaction.openOuter();){
                        EnergyP2PTunnelPart.this.queueTunnelDrain(PowerUnits.TR, extracted, (TransactionContext)tx);
                        if (simulation.isActing()) {
                            tx.commit();
                        }
                    }
                    long l = extracted;
                    return l;
                }
            }
            return 0L;
        }

        @Override
        public boolean canExtract(CableTier tier) {
            return tier == CableTier.SUPERCONDUCTOR;
        }
    }
}

