/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.blocks.creativetank.CreativeTankItem;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class TankItemBakedModel
implements FabricBakedModel,
class_1087 {
    private final class_1087 blockModel;
    private final RenderMaterial translucentMaterial;

    public TankItemBakedModel(class_1087 blockModel, RenderMaterial translucentMaterial) {
        this.blockModel = blockModel;
        this.translucentMaterial = translucentMaterial;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        context.fallbackConsumer().accept(this.blockModel);
        class_1792 it = stack.method_7909();
        if (it instanceof TankItem) {
            TankItem item = (TankItem)it;
            if (!item.isEmpty(stack)) {
                float fillFraction = (float)item.getAmount(stack) / (float)item.capacity;
                this.drawFluid(context.getEmitter(), fillFraction, item.getFluid(stack));
            }
        } else if (it instanceof CreativeTankItem && !CreativeTankItem.isEmpty(stack)) {
            this.drawFluid(context.getEmitter(), 1.0f, CreativeTankItem.getFluid(stack));
        }
    }

    private void drawFluid(QuadEmitter emitter, float fillFraction, FluidVariant fluid) {
        class_1058 stillSprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid) | 0xFF000000;
        for (class_2350 direction : class_2350.values()) {
            float topSpace;
            float depth;
            float bottomSpace;
            if (FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid)) {
                bottomSpace = direction.method_10166().method_10179() ? 1.0f - fillFraction + 0.01f : 0.0f;
                depth = direction == class_2350.field_11033 ? fillFraction : 0.0f;
                topSpace = 0.0f;
            } else {
                bottomSpace = 0.0f;
                topSpace = direction.method_10166().method_10179() ? 1.0f - fillFraction + 0.01f : 0.0f;
                depth = direction == class_2350.field_11036 ? 1.0f - fillFraction : 0.0f;
            }
            emitter.material(this.translucentMaterial);
            emitter.square(direction, 0.0f, bottomSpace, 1.0f, 1.0f - topSpace, depth + 0.01f);
            emitter.spriteBake(0, stillSprite, 4);
            emitter.spriteColor(0, color, color, color, color);
            emitter.emit();
        }
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, Random random) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.blockModel.method_4711();
    }

    public class_809 method_4709() {
        return this.blockModel.method_4709();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

