/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.blocks.TrashCanBlock;
import aztech.modern_industrialization.blocks.creativestorageunit.CreativeStorageUnitBlock;
import aztech.modern_industrialization.blocks.creativetank.CreativeTankBlock;
import aztech.modern_industrialization.blocks.creativetank.CreativeTankItem;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerBlock;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.TankPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1747;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2430;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3614;
import net.minecraft.class_4910;
import net.minecraft.class_4946;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class MIBlock {
    public static SortedMap<class_2960, BlockDefinition<?>> BLOCKS = new TreeMap();
    public static final BlockDefinition<ForgeHammerBlock> FORGE_HAMMER = MIBlock.block("Forge Hammer", "forge_hammer", BlockDefinitionParams.of().withBlockConstructor(ForgeHammerBlock::new).sortOrder(SortOrder.FORGE_HAMMER).noModel().method_36557(6.0f).method_36558(1200.0f).method_9626(class_2498.field_11531), ForgeHammerBlock.class);
    public static final BlockDefinition<TrashCanBlock> TRASH_CAN = MIBlock.block("Automatic Trash Can", "trash_can", BlockDefinitionParams.of().withBlockConstructor(TrashCanBlock::new).method_36557(6.0f).method_36558(1200.0f), TrashCanBlock.class).withBlockRegistrationEvent(TrashCanBlock::onRegister);
    public static final BlockDefinition<class_2248> BASIC_MACHINE_HULL = MIBlock.block("Basic Machine Hull", "basic_machine_hull");
    public static final BlockDefinition<class_2248> ADVANCED_MACHINE_HULL = MIBlock.block("Advanced Machine Hull", "advanced_machine_hull");
    public static final BlockDefinition<class_2248> TURBO_MACHINE_HULL = MIBlock.block("Turbo Machine Hull", "turbo_machine_hull");
    public static final BlockDefinition<class_2248> HIGHLY_ADVANCED_MACHINE_HULL = MIBlock.block("Highly Advanced Machine Hull", "highly_advanced_machine_hull");
    public static final BlockDefinition<class_2248> QUANTUM_MACHINE_HULL = MIBlock.block("Quantum Machine Hull", "quantum_machine_hull", (class_4970.class_2251)BlockDefinitionParams.of().resistance(6000.0f));
    public static final BlockDefinition<class_2248> FUSION_CHAMBER = MIBlock.block("Fusion Chamber", "fusion_chamber");
    public static final BlockDefinition<class_2248> INDUSTRIAL_TNT = MIBlock.blockExplosive("Industrial TNT", "industrial_tnt");
    public static final BlockDefinition<class_2248> NUKE = MIBlock.blockExplosive("Nuke", "nuke");
    public static final BlockDefinition<CreativeTankBlock> CREATIVE_TANK_BLOCK = MIBlock.block("Creative Tank", "creative_tank", BlockDefinitionParams.of().withBlockConstructor(CreativeTankBlock::new).withBlockItemConstructor(CreativeTankItem::new).withModel(TankPart.MODEL_GENERATOR).noLootTable().clearTags().method_22488(), CreativeTankBlock.class).withBlockRegistrationEvent((block, item) -> FluidStorage.ITEM.registerForItems(CreativeTankItem.TankItemStorage::new, new class_1935[]{item}));
    public static final BlockDefinition<CreativeStorageUnitBlock> CREATIVE_STORAGE_UNIT = MIBlock.block("Creative Storage Unit", "creative_storage_unit", BlockDefinitionParams.of().withBlockConstructor(CreativeStorageUnitBlock::new));
    public static final BlockDefinition<class_2248> BLOCK_FIRE_CLAY_BRICKS = MIBlock.block("Fire Clay Bricks", "fire_clay_bricks", BlockDefinitionParams.of(ModernIndustrialization.STONE_MATERIAL).sortOrder(SortOrder.MATERIALS.and((Comparable)((Object)"fire_clay"))).method_36557(2.0f).method_36558(6.0f).method_29292());

    private static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, T block, BiFunction<class_2248, FabricItemSettings, class_1747> blockItemCtor, BiConsumer<class_2248, class_4910> modelGenerator, BiConsumer<class_2248, class_2430> lootTableGenerator, List<class_6862<class_2248>> tags, SortOrder sortOrder) {
        BlockDefinition<T> definition = new BlockDefinition<T>(englishName, id, block, blockItemCtor, modelGenerator, lootTableGenerator, tags, sortOrder);
        if (BLOCKS.put(definition.getId(), definition) != null) {
            throw new IllegalArgumentException("Block id already taken : " + definition.getId());
        }
        return definition;
    }

    public static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, BlockDefinitionParams<T> params) {
        return MIBlock.block(englishName, id, (class_2248)params.ctor.apply((class_4970.class_2251)params), params.blockItemCtor, params.modelGenerator, params.lootTableGenerator, params.tags, params.sortOrder);
    }

    public static BlockDefinition<class_2248> block(String englishName, String id, class_4970.class_2251 params) {
        return MIBlock.block(englishName, id, params, class_2248.class);
    }

    public static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, class_4970.class_2251 params, Class<T> blockClass) {
        return MIBlock.block(englishName, id, (BlockDefinitionParams)params);
    }

    public static BlockDefinition<class_2248> block(String englishName, String id) {
        return MIBlock.block(englishName, id, BlockDefinitionParams.of());
    }

    public static BlockDefinition<class_2248> blockExplosive(String englishName, String id) {
        return MIBlock.block(englishName, id, BlockDefinitionParams.of(class_4970.class_2251.method_9637((class_3614)class_3614.field_15955).method_9618().method_9626(class_2498.field_11535)).clearTags().noModel());
    }

    public static class BlockDefinitionParams<T extends class_2248>
    extends FabricBlockSettings {
        public BiConsumer<class_2248, class_4910> modelGenerator;
        public BiConsumer<class_2248, class_2430> lootTableGenerator;
        public final ArrayList<class_6862<class_2248>> tags = new ArrayList();
        public SortOrder sortOrder = SortOrder.BLOCKS_OTHERS;
        public Function<class_4970.class_2251, T> ctor;
        public BiFunction<class_2248, FabricItemSettings, class_1747> blockItemCtor;

        protected BlockDefinitionParams(class_4970.class_2251 properties, Function<class_4970.class_2251, T> ctor, BiFunction<class_2248, FabricItemSettings, class_1747> blockItemCtor, BiConsumer<class_2248, class_4910> modelGenerator, BiConsumer<class_2248, class_2430> lootTableGenerator, List<class_6862<class_2248>> tags) {
            super(properties);
            this.ctor = ctor;
            this.blockItemCtor = blockItemCtor;
            this.modelGenerator = modelGenerator;
            this.lootTableGenerator = lootTableGenerator;
            this.tags.addAll(tags);
        }

        public static BlockDefinitionParams<class_2248> of(class_4970.class_2251 properties) {
            return new BlockDefinitionParams<class_2248>(properties, class_2248::new, class_1747::new, (block, modelGenerator) -> modelGenerator.method_25641(block), (block, lootGenerator) -> lootGenerator.method_16329(block), List.of(class_3481.field_33719, class_3481.field_33715));
        }

        public static BlockDefinitionParams<class_2248> of(class_3614 material) {
            return BlockDefinitionParams.of(FabricBlockSettings.of((class_3614)material).method_36557(4.0f).method_29292());
        }

        public static BlockDefinitionParams<class_2248> of() {
            return BlockDefinitionParams.of(ModernIndustrialization.METAL_MATERIAL);
        }

        public <U extends class_2248> BlockDefinitionParams<U> withBlockConstructor(Function<class_4970.class_2251, U> ctor) {
            return new BlockDefinitionParams<U>((class_4970.class_2251)this, ctor, this.blockItemCtor, this.modelGenerator, this.lootTableGenerator, this.tags);
        }

        public BlockDefinitionParams<T> withBlockItemConstructor(BiFunction<class_2248, FabricItemSettings, class_1747> blockItemCtor) {
            this.blockItemCtor = blockItemCtor;
            return this;
        }

        public BlockDefinitionParams<T> withModel(BiConsumer<class_2248, class_4910> modelGenerator) {
            this.modelGenerator = modelGenerator;
            return this;
        }

        public BlockDefinitionParams<T> withModel(class_4946.class_4947 model) {
            return this.withModel((class_2248 block, class_4910 blockModelGenerator) -> blockModelGenerator.method_25622(block, model));
        }

        public BlockDefinitionParams<T> withLootTable(BiConsumer<class_2248, class_2430> lootTableGenerator) {
            this.lootTableGenerator = lootTableGenerator;
            return this;
        }

        public BlockDefinitionParams<T> noModel() {
            this.modelGenerator = (block, modelGenerator) -> modelGenerator.method_25681(block);
            return this;
        }

        public BlockDefinitionParams<T> noLootTable() {
            this.lootTableGenerator = null;
            return this;
        }

        public BlockDefinitionParams<T> clearTags() {
            this.tags.clear();
            return this;
        }

        public BlockDefinitionParams<T> addMoreTags(class_6862<class_2248> ... tagsToAdd) {
            return this.addMoreTags(Arrays.asList(tagsToAdd));
        }

        public BlockDefinitionParams<T> addMoreTags(Collection<class_6862<class_2248>> tagsToAdd) {
            this.tags.addAll(tagsToAdd);
            return this;
        }

        public BlockDefinitionParams<T> sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }
    }
}

