/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ClimbingAnimal;
import com.starfish_studios.naturalist.entity.SleepingAnimal;
import com.starfish_studios.naturalist.entity.ai.goal.SearchForItemsGoal;
import com.starfish_studios.naturalist.entity.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Snake
extends ClimbingAnimal
implements SleepingAnimal,
class_5354,
IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.SNAKE_TEMPT_ITEMS);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(Snake.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(Snake.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> EAT_COUNTER = class_2945.method_12791(Snake.class, (class_2941)class_2943.field_13327);
    @Nullable
    private UUID persistentAngerTarget;

    public Snake(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5952(true);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23721, 6.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SnakeMeleeAttackGoal((class_1314)this, 1.75, true));
        this.field_6201.method_6277(2, (class_1352)new SearchForItemsGoal((class_1314)this, 1.2f, FOOD_ITEMS, 8.0, 8.0));
        this.field_6201.method_6277(3, new SleepGoal<Snake>(this));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((Snake)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, true, false, livingEntity -> {
            class_1621 slime;
            return livingEntity.method_5864().method_20210(NaturalistTags.EntityTypes.SNAKE_HOSTILES) || livingEntity instanceof class_1621 && (slime = (class_1621)livingEntity).method_7157();
        }));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    @Nullable
    public class_1296 method_5613(class_3218 p_146743_, class_1296 p_146744_) {
        return null;
    }

    public static boolean checkSnakeSpawnRules(class_1299<Snake> entityType, class_1936 level, class_3730 type, class_2338 pos, Random random) {
        return level.method_8320(pos.method_10074()).method_26164(class_3481.field_35573) && Snake.method_39448((class_1920)level, (class_2338)pos);
    }

    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        this.initEquipment(this.field_5974, pDifficulty);
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void initEquipment(Random random, class_1266 pDifficulty) {
        if (random.nextFloat() < 0.2f) {
            float chance = random.nextFloat();
            class_1799 stack = chance < 0.05f ? new class_1799((class_1935)class_1802.field_8073) : (chance < 0.1f ? new class_1799((class_1935)class_1802.field_8777) : (chance < 0.15f ? new class_1799((class_1935)class_1802.field_8153) : (chance < 0.3f ? new class_1799((class_1935)class_1802.field_8504) : new class_1799((class_1935)class_1802.field_8726))));
            this.method_5673(class_1304.field_6173, stack);
        }
    }

    public boolean method_6481(class_1799 pStack) {
        return false;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(EAT_COUNTER, (Object)0);
        this.field_6011.method_12784(REMAINING_ANGER_TIME, (Object)0);
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.method_29512(this.field_6002, pCompound);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        this.method_29517(pCompound);
    }

    public boolean isEating() {
        return (Integer)this.field_6011.method_12789(EAT_COUNTER) > 0;
    }

    public void eat(boolean eat) {
        this.field_6011.method_12778(EAT_COUNTER, (Object)(eat ? 1 : 0));
    }

    private int getEatCounter() {
        return (Integer)this.field_6011.method_12789(EAT_COUNTER);
    }

    private void setEatCounter(int amount) {
        this.field_6011.method_12778(EAT_COUNTER, (Object)amount);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, true);
        }
        if (this.method_6113() || this.method_6062()) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
        this.handleEating();
        if (!this.method_6047().method_7960() && this.method_29511()) {
            this.method_29922();
        }
        if (this.canRattle() && !this.method_6113()) {
            this.method_5783(NaturalistSoundEvents.SNAKE_RATTLE.get(), 0.15f, 1.0f);
        }
    }

    private void handleEating() {
        if (!(this.isEating() || this.method_6113() || this.method_6047().method_7960())) {
            this.eat(true);
        } else if (this.method_6047().method_7960()) {
            this.eat(false);
        }
        if (this.isEating()) {
            if (!this.field_6002.field_9236 && this.getEatCounter() > 6000) {
                if (!this.method_6047().method_7960() && !this.field_6002.field_9236) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                    this.method_32876(class_5712.field_28735);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    public boolean method_18397(class_1799 pItemstack) {
        class_1304 slot = class_1308.method_32326((class_1799)pItemstack);
        if (!this.method_6118(slot).method_7960()) {
            return false;
        }
        return slot == class_1304.field_6173 && super.method_18397(pItemstack);
    }

    protected void method_5949(class_1542 pItemEntity) {
        class_1799 stack = pItemEntity.method_6983();
        if (this.method_6047().method_7960() && FOOD_ITEMS.method_8093(stack)) {
            this.method_29499(pItemEntity);
            this.method_5673(class_1304.field_6173, stack);
            this.field_6187[class_1304.field_6173.method_5927()] = 2.0f;
            this.method_6103((class_1297)pItemEntity, stack.method_7947());
            pItemEntity.method_31472();
        }
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        if (!this.method_6047().method_7960() && !this.field_6002.field_9236) {
            class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317() + this.method_5720().field_1352, this.method_23318() + 1.0, this.method_23321() + this.method_5720().field_1350, this.method_6047());
            itemEntity.method_6982(80);
            itemEntity.method_6981(this.method_5667());
            this.method_5783(class_3417.field_18054, 1.0f, 1.0f);
            this.field_6002.method_8649((class_1297)itemEntity);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        return super.method_5643(pSource, pAmount);
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    public float method_6029() {
        return this.method_6047().method_7960() ? super.method_6029() : super.method_6029() * 0.5f;
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.field_6002.method_8532();
        if (this.method_29511() || this.field_6002.method_22351(this.method_24515())) {
            return false;
        }
        if (dayTime > 18000L && dayTime < 23000L) {
            return false;
        }
        return dayTime > 12000L && dayTime < 28000L;
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_29514(int pTime) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29513(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public boolean method_6121(class_1297 pEntity) {
        if ((this.method_5864().equals(NaturalistEntityTypes.CORAL_SNAKE.get()) || this.method_5864().equals(NaturalistEntityTypes.RATTLESNAKE.get())) && pEntity instanceof class_1309) {
            class_1309 living = (class_1309)pEntity;
            living.method_6092(new class_1293(class_1294.field_5899, 40));
        }
        return super.method_6121(pEntity);
    }

    private boolean canRattle() {
        List players = this.method_37908().method_18464(class_4051.method_36626().method_18418(4.0), (class_1309)this, this.method_5829().method_1009(4.0, 2.0, 4.0));
        return !players.isEmpty() && this.method_5864().equals(NaturalistEntityTypes.RATTLESNAKE.get());
    }

    protected float method_6107() {
        return 0.15f;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 pDamageSource) {
        return NaturalistSoundEvents.SNAKE_HURT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.method_6113()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.sleep", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.method_6101()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.climb", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!(event.getLimbSwingAmount() > -0.04f) || !(event.getLimbSwingAmount() < 0.04f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.move", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState attackPredicate(AnimationEvent<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.attack", Boolean.valueOf(false)));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState tonguePredicate(AnimationEvent<E> event) {
        if (this.field_5974.nextInt(1000) < this.field_6191 && !this.method_6113() && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.tongue", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState rattlePredicate(AnimationEvent<E> event) {
        if (this.canRattle() && !this.method_6113()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snake.rattle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private void soundListener(SoundKeyframeEvent<Snake> event) {
        Snake snake = (Snake)event.getEntity();
        if (snake.field_6002.field_9236 && event.sound.equals("hiss")) {
            snake.field_6002.method_8486(snake.method_23317(), snake.method_23318(), snake.method_23321(), NaturalistSoundEvents.SNAKE_HISS.get(), snake.method_5634(), snake.method_6107(), snake.method_6017(), false);
        }
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
        AnimationController tongueController = new AnimationController((IAnimatable)this, "tongueController", 0.0f, this::tonguePredicate);
        tongueController.registerSoundListener(this::soundListener);
        data.addAnimationController(tongueController);
        data.addAnimationController(new AnimationController((IAnimatable)this, "rattleController", 0.0f, this::rattlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SnakeMeleeAttackGoal
    extends class_1366 {
        public SnakeMeleeAttackGoal(class_1314 pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean method_6264() {
            return this.field_6503.method_6047().method_7960() && super.method_6264();
        }

        public boolean method_6266() {
            return this.field_6503.method_6047().method_7960() && super.method_6266();
        }

        protected double method_6289(class_1309 pAttackTarget) {
            return 4.0f + pAttackTarget.method_17681();
        }
    }
}

