/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm.api;

import com.chocohead.mm.api.EnumAdder;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.tree.ClassNode;

public enum ClassTinkerers {
    INSTANCE;

    private Predicate<URL> urlers = url -> false;
    private Map<String, byte[]> clazzes = new HashMap<String, byte[]>();
    private Map<String, Consumer<ClassNode>> replacers = new HashMap<String, Consumer<ClassNode>>();
    private Map<String, Set<Consumer<ClassNode>>> tinkerers = new HashMap<String, Set<Consumer<ClassNode>>>();
    private Set<EnumAdder> enumExtensions = new HashSet<EnumAdder>();

    public void hookUp(Consumer<URL> liveURL, Map<String, byte[]> liveClassMap, Map<String, Consumer<ClassNode>> liveReplacers, Map<String, Set<Consumer<ClassNode>>> liveTinkerers, Set<EnumAdder> liveEnums) {
        this.urlers = url -> {
            liveURL.accept((URL)url);
            return true;
        };
        liveClassMap.putAll(this.clazzes);
        this.clazzes = liveClassMap;
        liveReplacers.putAll(this.replacers);
        this.replacers = liveReplacers;
        liveTinkerers.putAll(this.tinkerers);
        this.tinkerers = liveTinkerers;
        liveEnums.addAll(this.enumExtensions);
        this.enumExtensions = liveEnums;
    }

    public static boolean addURL(URL url) {
        return ClassTinkerers.INSTANCE.urlers.test(url);
    }

    public static boolean define(String name, byte[] contents) {
        name = '/' + name.replace('.', '/') + ".class";
        if (ClassTinkerers.INSTANCE.clazzes.containsKey(name)) {
            return false;
        }
        if (contents == null) {
            throw new IllegalArgumentException("Tried to define null class named " + name);
        }
        ClassTinkerers.INSTANCE.clazzes.put(name, contents);
        return true;
    }

    public static void addReplacement(String target, Consumer<ClassNode> replacer) {
        if (replacer == null) {
            throw new IllegalArgumentException("Tried to set null replacer for " + target);
        }
        String name = target.replace('.', '/');
        Consumer<ClassNode> existing = ClassTinkerers.INSTANCE.replacers.get(name);
        if (existing != null) {
            throw new IllegalStateException("Multiple attempts to replace " + name + ": " + existing + " and " + replacer);
        }
        ClassTinkerers.INSTANCE.replacers.put(name, replacer);
    }

    public static void addTransformation(String target, Consumer<ClassNode> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Tried to add null transformer for " + target);
        }
        ClassTinkerers.INSTANCE.tinkerers.computeIfAbsent(target.replace('.', '/'), k -> new HashSet()).add(transformer);
    }

    public static EnumAdder enumBuilder(String type) {
        if (type == null) {
            throw new NullPointerException("Tried to add onto a null type!");
        }
        return new EnumAdder(type.replace('.', '/'), ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    public static EnumAdder enumBuilder(String type, Class<?> ... parameterTypes) {
        if (type == null) {
            throw new NullPointerException("Tried to add onto a null type!");
        }
        if (parameterTypes == null || ArrayUtils.contains((Object[])parameterTypes, null)) {
            throw new IllegalArgumentException("Invalid parameter array: " + Arrays.toString(parameterTypes));
        }
        for (Class<?> param : parameterTypes) {
            if (!param.getName().startsWith("net.minecraft.")) continue;
            throw new IllegalArgumentException("Early loaded " + param.getName());
        }
        return new EnumAdder(type.replace('.', '/'), parameterTypes);
    }

    public static EnumAdder enumBuilder(String type, String ... parameterTypes) {
        if (type == null) {
            throw new NullPointerException("Tried to add onto a null type!");
        }
        if (parameterTypes == null || ArrayUtils.contains((Object[])parameterTypes, null)) {
            throw new IllegalArgumentException("Invalid parameter array: " + Arrays.toString(parameterTypes));
        }
        return new EnumAdder(type.replace('.', '/'), (String[])Arrays.stream(parameterTypes).map(param -> param.replace('.', '/')).toArray(String[]::new));
    }

    public static EnumAdder enumBuilder(String type, Object ... parameterTypes) {
        if (type == null) {
            throw new NullPointerException("Tried to add onto a null type!");
        }
        if (parameterTypes == null || ArrayUtils.contains((Object[])parameterTypes, null)) {
            throw new IllegalArgumentException("Invalid parameter array: " + Arrays.toString(parameterTypes));
        }
        return new EnumAdder(type.replace('.', '/'), parameterTypes);
    }

    static void addEnum(EnumAdder builder) {
        if (ArrayUtils.contains((Object[])builder.parameterTypes, null)) {
            throw new IllegalArgumentException("Builder for " + builder.type + " has an invalid parameter array: " + Arrays.toString(builder.parameterTypes));
        }
        if (!builder.getAdditions().isEmpty()) {
            ClassTinkerers.INSTANCE.enumExtensions.add(builder);
        }
    }

    public static <E extends Enum<E>> E getEnum(Class<E> type, String name) {
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            if (!constant.name().equals(name)) continue;
            return (E)constant;
        }
        throw new IllegalArgumentException("Unable to find " + name + " in " + type);
    }
}

