/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import com.chocohead.mm.CorrectedMethod;
import com.chocohead.mm.CorrectedMethods;
import com.chocohead.mm.api.EnumAdder;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.util.Annotations;

final class EnumSubclasser {
    private static final Map<EnumAdder.EnumAddition, StructClass> ADDITION_TO_CHANGES = new IdentityHashMap<EnumAdder.EnumAddition, StructClass>();
    private static final Map<String, StructClass> STRUCTS_TO_CLASS = new HashMap<String, StructClass>();
    private static final Set<String> STRUCT_MIXINS = new HashSet<String>();

    EnumSubclasser() {
    }

    static byte[] defineAnonymousSubclass(ClassNode enumNode, EnumAdder.EnumAddition addition, String anonymousClassName, String constructor) {
        ClassWriter writer = new ClassWriter(2);
        Type enumType = Type.getObjectType((String)enumNode.name);
        Type thisType = Type.getObjectType((String)anonymousClassName);
        Type structType = Type.getObjectType((String)addition.structClass);
        writer.visit(52, 16433, anonymousClassName, null, enumNode.name, null);
        writer.visitOuterClass(enumType.getInternalName(), null, null);
        writer.visitField(18, "struct", structType.getDescriptor(), null, null).visitEnd();
        Method method = new Method("<init>", constructor);
        GeneratorAdapter generator = new GeneratorAdapter(0, method, null, null, (ClassVisitor)writer);
        generator.loadThis();
        generator.loadArgs();
        generator.invokeConstructor(enumType, method);
        generator.loadThis();
        generator.newInstance(structType);
        generator.dup();
        generator.invokeConstructor(structType, new Method("<init>", "()V"));
        generator.putField(thisType, "struct", structType);
        generator.returnValue();
        generator.endMethod();
        StructClass struct = EnumSubclasser.loadStruct(enumType.getDescriptor(), anonymousClassName, addition);
        assert (struct.name.equals(structType.getInternalName()));
        HashMap gains = new HashMap();
        Map toMatch = enumNode.methods.stream().collect(Collectors.toMap(m -> m.name + m.desc, Function.identity()));
        Map overrides = EnumSubclasser.getParentStructs(struct).stream().flatMap(node -> node.methods.stream()).peek(m -> {
            AnnotationNode annotations;
            AnnotationNode annotation = Annotations.getInvisible((MethodNode)m, CorrectedMethod.class);
            List<Object> corrections = annotation != null ? Collections.singletonList(annotation) : ((annotations = Annotations.getInvisible((MethodNode)m, CorrectedMethods.class)) != null ? (List)Annotations.getValue((AnnotationNode)annotation) : Collections.emptyList());
            for (AnnotationNode correction : corrections) {
                String from = (String)Annotations.getValue((AnnotationNode)correction, (String)"from");
                String to = (String)Annotations.getValue((AnnotationNode)correction, (String)"to");
                String previous = gains.put(from, to);
                assert (previous == null || previous.equals(to));
            }
        }).filter(m -> m.name.charAt(0) != '<' && !Modifier.isPrivate(m.access) && !Modifier.isStatic(m.access)).map(m -> m.name + m.desc).filter(toMatch::containsKey).collect(Collectors.toMap(Function.identity(), toMatch::get));
        for (Map.Entry entry : overrides.entrySet()) {
            MethodNode override = entry.getValue();
            assert (!Modifier.isFinal(override.access));
            assert (!Modifier.isPrivate(override.access));
            assert (!Modifier.isNative(override.access));
            method = EnumSubclasser.makeMethod((String)entry.getKey());
            generator = new GeneratorAdapter(override.access & 0xFFFFFBFF, method, override.signature, (Type[])override.exceptions.stream().map(Type::getObjectType).toArray(Type[]::new), (ClassVisitor)writer);
            generator.loadThis();
            generator.getField(thisType, "struct", structType);
            generator.loadArgs();
            generator.invokeVirtual(structType, method);
            generator.returnValue();
            generator.endMethod();
        }
        for (Map.Entry<Object, Object> entry : gains.entrySet()) {
            String to = (String)entry.getValue();
            assert (!toMatch.containsKey(to));
            method = EnumSubclasser.makeMethod(to);
            generator = new GeneratorAdapter(4161, method, null, null, (ClassVisitor)writer);
            generator.loadThis();
            generator.loadArgs();
            generator.invokeConstructor(enumType, EnumSubclasser.makeMethod((String)entry.getKey()));
            generator.returnValue();
            generator.endMethod();
        }
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static Method makeMethod(String nameDesc) {
        int split = nameDesc.indexOf(40);
        return new Method(nameDesc.substring(0, split), nameDesc.substring(split));
    }

    private static synchronized StructClass loadStruct(String enumDescriptor, String newOwner, EnumAdder.EnumAddition addition) {
        StructClass node = ADDITION_TO_CHANGES.get(addition);
        if (node != null && node.isFixed()) {
            return node;
        }
        node = STRUCTS_TO_CLASS.get(addition.structClass);
        if (node != null && node.isFixed()) {
            ADDITION_TO_CHANGES.put(addition, node);
            return node;
        }
        if (node == null) {
            StructClassVisitor visitor;
            try {
                InputStream in = EnumSubclasser.class.getResourceAsStream(addition.structClass + ".class");
                Object object = null;
                try {
                    assert (in != null) : "Unable to find provided struct class " + addition.structClass;
                    visitor = new StructClassVisitor();
                    new ClassReader(in).accept((ClassVisitor)visitor, 4);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find provided struct class " + addition.structClass, e);
            }
            assert (!visitor.isMixin());
            node = visitor.asStruct();
        }
        List<StructClass> parents = EnumSubclasser.getParentStructs(node);
        assert (!parents.isEmpty() && parents.get(0) == node);
        String mixin = ((StructClass)Iterables.getLast(parents)).switchParent(Object.class.getName().replace('.', '/'));
        for (StructClass struct : parents) {
            HashMap<String, String> bridges = new HashMap<String, String>();
            block16: for (MethodNode method : struct.methods) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                for (AbstractInsnNode insn : method.instructions) {
                    int i;
                    AbstractInsnNode previous;
                    if (insn.getType() != 5 || !mixin.equals(((MethodInsnNode)insn).owner)) continue;
                    assert (!struct.isFixed());
                    MethodInsnNode mInsn = (MethodInsnNode)insn;
                    assert (insn.getOpcode() != 184);
                    int argSize = Type.getArgumentsAndReturnSizes((String)mInsn.desc) >> 2;
                    boolean easySwap = true;
                    if (argSize > 1) {
                        previous = insn;
                        for (i = 0; i < argSize; ++i) {
                            if ((previous = previous.getPrevious()).getType() == 2 && EnumSubclasser.isVarLoad(previous.getOpcode())) continue;
                            easySwap = false;
                            break;
                        }
                    }
                    if (insn.getOpcode() == 183) {
                        if ("<init>".equals(mInsn.name)) {
                            mInsn.owner = struct.getParent();
                            continue;
                        }
                        String newName = "MMsuper\u00a3" + mInsn.name;
                        replacements.put(mInsn.name + mInsn.desc, newName + mInsn.desc);
                        mInsn.owner = easySwap ? newOwner : struct.name;
                        mInsn.name = newName;
                        if (easySwap) {
                            mInsn.setOpcode(182);
                        }
                    } else {
                        String string = mInsn.owner = easySwap ? newOwner : struct.name;
                        if (!easySwap) {
                            mInsn.setOpcode(183);
                        }
                    }
                    if (easySwap) {
                        previous = insn;
                        assert (argSize >= 1);
                        for (i = 0; i < argSize; ++i) {
                            previous = previous.getPrevious();
                        }
                        if (previous.getType() != 2 || ((VarInsnNode)previous).var != 0) {
                            throw new IllegalStateException("Not quite sure how to handle the bytecode, previous was " + previous.getType());
                        }
                        assert (EnumSubclasser.isVarLoad(previous.getOpcode()));
                        method.instructions.insert(previous, (AbstractInsnNode)new TypeInsnNode(192, newOwner));
                        method.instructions.set(previous, (AbstractInsnNode)new FieldInsnNode(178, newOwner, addition.name, enumDescriptor));
                        continue;
                    }
                    String bridge = "MMbridge\u00a3" + (mInsn.name.startsWith("MMsuper\u00a3") ? mInsn.name.substring(8) : mInsn.name);
                    String previous2 = bridges.put(bridge + mInsn.desc, mInsn.name + mInsn.desc);
                    assert (previous2 == null || previous2.equals(mInsn.name + mInsn.desc));
                    mInsn.name = bridge;
                }
                switch (replacements.size()) {
                    case 0: {
                        continue block16;
                    }
                    case 1: {
                        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(replacements.entrySet());
                        Annotations.setInvisible((MethodNode)method, CorrectedMethod.class, (Object[])new Object[]{"from", entry.getKey(), "to", entry.getValue()});
                        continue block16;
                    }
                }
                AnnotationNode annotationNode = new AnnotationNode(Type.getDescriptor(CorrectedMethods.class));
                AnnotationVisitor annotations = annotationNode.visitArray("value");
                String correctedMethod = Type.getDescriptor(CorrectedMethod.class);
                for (Map.Entry entry : replacements.entrySet()) {
                    AnnotationVisitor nest = annotations.visitAnnotation(null, correctedMethod);
                    nest.visit("from", entry.getKey());
                    nest.visit("to", entry.getValue());
                    nest.visitEnd();
                }
                annotations.visitEnd();
                method.invisibleAnnotations.add(annotationNode);
            }
            if (!bridges.isEmpty()) {
                Type newOwnerType = Type.getObjectType((String)newOwner);
                Type enumType = Type.getType((String)enumDescriptor);
                for (Map.Entry entry : bridges.entrySet()) {
                    Method bridge = EnumSubclasser.makeMethod((String)entry.getKey());
                    MethodNode method = new MethodNode(4162, bridge.getName(), bridge.getDescriptor(), null, null);
                    struct.methods.add(method);
                    GeneratorAdapter generator = new GeneratorAdapter(method.access, bridge, (MethodVisitor)method);
                    generator.getStatic(newOwnerType, addition.name, enumType);
                    generator.checkCast(newOwnerType);
                    generator.loadArgs();
                    generator.invokeVirtual(newOwnerType, EnumSubclasser.makeMethod((String)entry.getValue()));
                    generator.returnValue();
                    generator.endMethod();
                }
            }
            struct.setFixed();
        }
        ADDITION_TO_CHANGES.put(addition, node);
        return node;
    }

    private static boolean isVarLoad(int opcode) {
        return opcode == 21 || opcode == 22 || opcode == 23 || opcode == 24 || opcode == 25;
    }

    static List<StructClass> getParentStructs(String name) {
        StructClass start = EnumSubclasser.loadSuperStruct(name);
        if (start == null) {
            throw new IllegalArgumentException("Cannot get parents of Mixins");
        }
        List<StructClass> parents = EnumSubclasser.getParentStructs(start);
        return parents.subList(1, parents.size());
    }

    private static List<StructClass> getParentStructs(StructClass start) {
        String parent;
        ArrayList<StructClass> parents = new ArrayList<StructClass>();
        StructClass child = start;
        do {
            parents.add(child);
            parent = child.getParent();
            if (parent != null && !parent.startsWith("java/lang/")) continue;
            if (child.isFixed()) {
                return parents;
            }
            throw new IllegalStateException(parents.stream().map(node -> node.name).collect(Collectors.joining("Missing Mixin from struct hierachy ", " => ", " => " + parent)));
        } while ((child = EnumSubclasser.loadSuperStruct(parent)) != null);
        return parents;
    }

    private static synchronized StructClass loadSuperStruct(String name) {
        StructClassVisitor node;
        StructClass struct = STRUCTS_TO_CLASS.get(name);
        if (struct != null) {
            return struct;
        }
        if (STRUCT_MIXINS.contains(name)) {
            return null;
        }
        for (Map.Entry<EnumAdder.EnumAddition, StructClass> entry : ADDITION_TO_CHANGES.entrySet()) {
            if (!entry.getKey().structClass.equals(name)) continue;
            return entry.getValue();
        }
        try (InputStream in = EnumSubclasser.class.getResourceAsStream('/' + name + ".class");){
            assert (in != null) : "Unable to find provided struct class " + name;
            node = new StructClassVisitor();
            new ClassReader(in).accept((ClassVisitor)node, 4);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find provided struct class " + name, e);
        }
        if (node.isMixin()) {
            STRUCT_MIXINS.add(name);
            return null;
        }
        struct = node.asStruct();
        STRUCTS_TO_CLASS.put(name, struct);
        return struct;
    }

    static Consumer<ClassNode> makeStructFixer(EnumAdder.EnumAddition addition, String target) {
        return node -> {
            assert (node.name.equals(addition.structClass));
            Class<EnumSubclasser> clazz = EnumSubclasser.class;
            synchronized (EnumSubclasser.class) {
                StructClass replacement = ADDITION_TO_CHANGES.get(addition);
                if (replacement == null) {
                    try {
                        Class.forName(target.replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load target enum " + target + " for " + addition.name + " => " + addition.structClass);
                    }
                    replacement = ADDITION_TO_CHANGES.get(addition);
                    if (replacement == null) {
                        throw new IllegalStateException("Unable to find " + target + " for " + addition.name + " => " + addition.structClass);
                    }
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                assert (replacement != null);
                EnumSubclasser.applyStructFixes(node, replacement);
                return;
            }
        };
    }

    static Consumer<ClassNode> makeStructFixer(String parent, String target) {
        return node -> {
            Class<EnumSubclasser> clazz = EnumSubclasser.class;
            synchronized (EnumSubclasser.class) {
                StructClass replacement = STRUCTS_TO_CLASS.get(parent);
                if (replacement == null) {
                    try {
                        Class.forName(target.replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load target enum " + target + " for super struct " + parent);
                    }
                    replacement = STRUCTS_TO_CLASS.get(parent);
                    if (replacement == null) {
                        throw new IllegalStateException("Unable to find " + target + " for super struct " + parent);
                    }
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                assert (replacement != null);
                EnumSubclasser.applyStructFixes(node, replacement);
                return;
            }
        };
    }

    private static void applyStructFixes(ClassNode target, StructClass fixes) {
        assert (fixes.isFixed());
        target.superName = fixes.getParent();
        target.methods = fixes.methods;
    }

    static final class StructClass {
        private boolean isFixed;
        public final String name;
        private String parent;
        public final List<MethodNode> methods;

        StructClass(String name, String parent, List<MethodNode> methods) {
            this.name = name;
            this.parent = parent;
            this.methods = methods;
        }

        public StructClass(ClassNode node) {
            this.name = node.name;
            this.parent = node.superName;
            this.methods = node.methods;
        }

        boolean isFixed() {
            return this.isFixed;
        }

        void setFixed() {
            this.isFixed = true;
        }

        public String getParent() {
            return this.parent;
        }

        String switchParent(String name) {
            String old = this.parent;
            this.parent = name;
            return old;
        }
    }

    private static final class StructClassVisitor
    extends ClassVisitor {
        private static final String MIXIN = Type.getDescriptor(Mixin.class);
        private final List<MethodNode> methods = new ArrayList<MethodNode>();
        private String name;
        private String parent;
        private boolean isMixin;
        private boolean hasRead;

        public StructClassVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            this.parent = superName;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (!visible && !this.isMixin) {
                this.isMixin = MIXIN.equals(descriptor);
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodNode method = new MethodNode(access, name, descriptor, signature, exceptions);
            this.methods.add(method);
            return method;
        }

        public void visitEnd() {
            this.hasRead = true;
        }

        public boolean isMixin() {
            if (!this.hasRead) {
                throw new IllegalStateException("Haven't visited class");
            }
            return this.isMixin;
        }

        public StructClass asStruct() {
            if (!this.hasRead) {
                throw new IllegalStateException("Haven't visited class");
            }
            if (this.isMixin) {
                throw new IllegalArgumentException("Tried to turn Mixin into a struct");
            }
            return new StructClass(this.name, this.parent, this.methods);
        }
    }
}

