/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.trackers;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.RemovableIdList;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class IdListTracker<V, OV>
implements RegistryEntryAddedCallback<V>,
RegistryIdRemapCallback<V>,
RegistryEntryRemovedCallback<V> {
    private final String name;
    private final class_2361<OV> mappers;
    private Map<class_2960, OV> removedMapperCache = new HashMap<class_2960, OV>();

    private IdListTracker(String name, class_2361<OV> mappers) {
        this.name = name;
        this.mappers = mappers;
    }

    public static <V, OV> void register(class_2378<V> registry, String name, class_2361<OV> mappers) {
        IdListTracker<V, OV> updater = new IdListTracker<V, OV>(name, mappers);
        RegistryEntryAddedCallback.event(registry).register(updater);
        RegistryIdRemapCallback.event(registry).register(updater);
        RegistryEntryRemovedCallback.event(registry).register(updater);
    }

    @Override
    public void onEntryAdded(int rawId, class_2960 id, V object) {
        if (this.removedMapperCache.containsKey(id)) {
            this.mappers.method_10203(this.removedMapperCache.get(id), rawId);
        }
    }

    @Override
    public void onRemap(RegistryIdRemapCallback.RemapState<V> state) {
        ((RemovableIdList)this.mappers).fabric_remapIds(state.getRawIdChangeMap());
    }

    @Override
    public void onEntryRemoved(int rawId, class_2960 id, V object) {
        if (this.mappers.method_10200(rawId) != null) {
            this.removedMapperCache.put(id, this.mappers.method_10200(rawId));
            ((RemovableIdList)this.mappers).fabric_removeId(rawId);
        }
    }
}

