/*
 * Decompiled with CFR 0.152.
 */
package io.github.tropheusj.serialization_hooks.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.tropheusj.serialization_hooks.SerializationHooks;
import io.github.tropheusj.serialization_hooks.ingredient.CombinedIngredient;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public interface IngredientDeserializer {
    public static final class_2378<IngredientDeserializer> REGISTRY = FabricRegistryBuilder.createSimple(IngredientDeserializer.class, (class_2960)SerializationHooks.id("ingredient_deserializers")).attribute(RegistryAttribute.SYNCED).buildAndRegister();
    public static final List<class_2960> KNOWN_MISSING = new ArrayList<class_2960>();

    public class_1856 fromNetwork(class_2540 var1);

    public class_1856 fromJson(JsonObject var1);

    public static void init() {
        class_2378.method_10230(REGISTRY, (class_2960)CombinedIngredient.Deserializer.ID, (Object)CombinedIngredient.Deserializer.INSTANCE);
    }

    @Nullable
    public static class_1856 tryDeserializeJson(JsonObject object) {
        JsonElement type = object.get("type");
        if (type != null && type.isJsonPrimitive()) {
            class_2960 id = class_2960.method_12829((String)type.getAsString());
            if (id == null) {
                return null;
            }
            IngredientDeserializer deserializer = (IngredientDeserializer)REGISTRY.method_10223(id);
            if (deserializer != null) {
                try {
                    return deserializer.fromJson(object);
                }
                catch (JsonSyntaxException ex) {
                    SerializationHooks.LOGGER.error("Failed to deserialize Ingredient using deserializer [{}]: {}", (Object)id, (Object)ex.getMessage());
                }
            }
            if (KNOWN_MISSING.contains(id)) {
                return null;
            }
            KNOWN_MISSING.add(id);
            SerializationHooks.LOGGER.error("IngredientDeserializer with ID not found: [{}] this can be ignored unless issues occur.", (Object)id);
        }
        return null;
    }

    @Nullable
    public static class_1856 tryDeserializeNetwork(class_2540 buf) {
        int readIndex = buf.readerIndex();
        try {
            class_2960 id = class_2960.method_12829((String)buf.method_19772());
            if (id != null && !id.method_12832().isEmpty()) {
                IngredientDeserializer deserializer = (IngredientDeserializer)REGISTRY.method_10223(id);
                if (deserializer != null) {
                    return deserializer.fromNetwork(buf);
                }
                if (KNOWN_MISSING.contains(id)) {
                    return null;
                }
                KNOWN_MISSING.add(id);
                SerializationHooks.LOGGER.error("IngredientDeserializer with ID not found: [{}] this can be ignored unless issues occur.", (Object)id);
            }
            buf.readerIndex(readIndex);
            return null;
        }
        catch (DecoderException e) {
            buf.readerIndex(readIndex);
            return null;
        }
    }
}

