/*
 * Decompiled with CFR 0.152.
 */
package io.github.tropheusj.serialization_hooks.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.tropheusj.serialization_hooks.SerializationHooks;
import io.github.tropheusj.serialization_hooks.ingredient.BaseCustomIngredient;
import io.github.tropheusj.serialization_hooks.ingredient.IngredientDeserializer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CombinedIngredient
extends BaseCustomIngredient {
    public final List<class_1856> children;
    private final class_1799[] items;
    private final IntList stackingIds;
    private final boolean empty;

    public CombinedIngredient(List<class_1856> children) {
        this.children = children;
        this.items = (class_1799[])children.stream().flatMap(c -> Arrays.stream(c.method_8105())).toArray(class_1799[]::new);
        this.stackingIds = new IntArrayList(children.stream().flatMapToInt(c -> c.method_8100().intStream()).toArray());
        this.empty = children.stream().allMatch(class_1856::method_8103);
    }

    public CombinedIngredient(class_1856 ... children) {
        this(List.of(children));
    }

    @Override
    public IngredientDeserializer getDeserializer() {
        return Deserializer.INSTANCE;
    }

    public boolean method_8093(@Nullable class_1799 itemStack) {
        for (class_1856 child : this.children) {
            if (!child.method_8093(itemStack)) continue;
            return true;
        }
        return false;
    }

    public class_1799[] method_8105() {
        return this.items;
    }

    public IntList method_8100() {
        return this.stackingIds;
    }

    public boolean method_8103() {
        return this.empty;
    }

    public void method_8088(class_2540 buffer) {
        buffer.method_10812(Deserializer.ID);
        buffer.method_10804(this.children.size());
        for (class_1856 child : this.children) {
            child.method_8088(buffer);
        }
    }

    public JsonElement method_8089() {
        JsonArray children = new JsonArray();
        for (class_1856 child : this.children) {
            children.add(child.method_8089());
        }
        return children;
    }

    public static class Deserializer
    implements IngredientDeserializer {
        public static final class_2960 ID = SerializationHooks.id("combined");
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        public class_1856 fromNetwork(class_2540 buffer) {
            int count = buffer.method_10816();
            ArrayList<class_1856> children = new ArrayList<class_1856>(count);
            for (int i = 0; i < count; ++i) {
                children.add(class_1856.method_8086((class_2540)buffer));
            }
            return new CombinedIngredient(children);
        }

        @Override
        public class_1856 fromJson(JsonObject object) {
            JsonElement childrenElement = object.get("children");
            if (!(childrenElement instanceof JsonArray)) {
                throw new JsonSyntaxException("CombinedIngredient expected JSON element to be an array, found: " + childrenElement);
            }
            JsonArray array = (JsonArray)childrenElement;
            ArrayList<class_1856> children = new ArrayList<class_1856>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                children.add(class_1856.method_8102((JsonElement)array.get(i)));
            }
            return new CombinedIngredient(children);
        }
    }
}

