/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_757;

public class RaycastRenderer {
    private static final List<Ray> rays = Collections.synchronizedList(new ArrayList());
    private static final class_310 mc = class_310.method_1551();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderRays(double x, double y, double z) {
        if (RaycastRenderer.mc.field_1687 == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue() && !SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            List<Ray> list = rays;
            synchronized (list) {
                rays.clear();
            }
            return;
        }
        long gameTime = RaycastRenderer.mc.field_1687.method_8510();
        List<Ray> list = rays;
        synchronized (list) {
            rays.removeIf(ray -> gameTime - ray.tickCreated > ray.lifespan || gameTime - ray.tickCreated < 0L);
            for (Ray ray2 : rays) {
                RaycastRenderer.renderRay(ray2, x, y, z);
            }
        }
    }

    public static void addSoundBounceRay(class_243 start, class_243 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, false);
    }

    public static void addOcclusionRay(class_243 start, class_243 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRay(class_243 start, class_243 end, int color, boolean throughWalls) {
        if (RaycastRenderer.mc.field_1724.method_19538().method_1022(start) > 32.0 && RaycastRenderer.mc.field_1724.method_19538().method_1022(end) > 32.0) {
            return;
        }
        List<Ray> list = rays;
        synchronized (list) {
            rays.add(new Ray(start, end, color, throughWalls));
        }
    }

    public static void renderRay(Ray ray, double x, double y, double z) {
        int red = RaycastRenderer.getRed(ray.color);
        int green = RaycastRenderer.getGreen(ray.color);
        int blue = RaycastRenderer.getBlue(ray.color);
        if (!ray.throughWalls) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        bufferBuilder.method_22912(ray.start.field_1352 - x, ray.start.field_1351 - y, ray.start.field_1350 - z).method_1336(red, green, blue, 255).method_1344();
        bufferBuilder.method_22912(ray.end.field_1352 - x, ray.end.field_1351 - y, ray.end.field_1350 - z).method_1336(red, green, blue, 255).method_1344();
        tesselator.method_1350();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
    }

    private static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int getBlue(int argb) {
        return argb & 0xFF;
    }

    private static class Ray {
        private final class_243 start;
        private final class_243 end;
        private final int color;
        private final long tickCreated;
        private final long lifespan;
        private final boolean throughWalls;

        public Ray(class_243 start, class_243 end, int color, boolean throughWalls) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.throughWalls = throughWalls;
            this.tickCreated = RaycastRenderer.mc.field_1687.method_8510();
            this.lifespan = 40L;
        }
    }
}

