/*
 * Decompiled with CFR 0.152.
 */
package io.github.tropheusj.dripstone_fluid_lib;

import io.github.tropheusj.dripstone_fluid_lib.Constants;
import io.github.tropheusj.dripstone_fluid_lib.DripstoneFluidParticle;
import io.github.tropheusj.dripstone_fluid_lib.DripstoneInteractingFluid;
import io.github.tropheusj.dripstone_fluid_lib.mixin.WaterSplashParticle$SplashFactoryAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_663;
import net.minecraft.class_703;
import net.minecraft.class_719;

@Environment(value=EnvType.CLIENT)
public class ParticleFactories {

    public static class DripstoneFluidSplashFactory
    extends class_719.class_720 {
        private final DripstoneInteractingFluid fluid;

        public DripstoneFluidSplashFactory(class_4002 spriteProvider, DripstoneInteractingFluid fluid) {
            super(spriteProvider);
            this.fluid = fluid;
        }

        public class_703 method_3102(class_2400 defaultParticleType, class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            DripstoneFluidParticle particle = new DripstoneFluidParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            particle.method_18140(((WaterSplashParticle$SplashFactoryAccessor)((Object)this)).dripstone_fluid_lib$spriteProvider());
            int color = this.fluid.getParticleColor((class_1937)clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            particle.method_3084(r, g, b);
            return particle;
        }
    }

    public static class FallingDripstoneFluidFactory
    extends class_663.class_5695 {
        private final DripstoneInteractingFluid fluid;

        public FallingDripstoneFluidFactory(class_4002 spriteProvider, DripstoneInteractingFluid fluid) {
            super(spriteProvider);
            this.fluid = fluid;
        }

        public class_703 method_32794(class_2400 defaultParticleType, class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            class_663.class_5692 particle = new class_663.class_5692(clientWorld, x, y, z, (class_3611)class_3612.field_15910, (class_2394)Constants.FLUIDS_TO_PARTICLES.get(this.fluid).splash());
            particle.method_18140(this.field_28073);
            int color = this.fluid.getParticleColor((class_1937)clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            particle.method_3084(r, g, b);
            return particle;
        }
    }

    public static class DrippingDripstoneFluidFactory
    extends class_663.class_5696 {
        private final DripstoneInteractingFluid fluid;

        public DrippingDripstoneFluidFactory(class_4002 spriteProvider, DripstoneInteractingFluid fluid) {
            super(spriteProvider);
            this.fluid = fluid;
        }

        public class_703 method_32795(class_2400 defaultParticleType, class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            class_663.class_4084 particle = new class_663.class_4084(clientWorld, x, y, z, (class_3611)class_3612.field_15910, (class_2394)Constants.FLUIDS_TO_PARTICLES.get(this.fluid).fall());
            particle.method_18140(this.field_28074);
            int color = this.fluid.getParticleColor((class_1937)clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            particle.method_3084(r, g, b);
            return particle;
        }
    }
}

