/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.simple;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageDecoder;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.class_2960;

public class SimpleNetworkManager {
    public final String namespace;

    public static SimpleNetworkManager create(String namespace) {
        return new SimpleNetworkManager(namespace);
    }

    private SimpleNetworkManager(String namespace) {
        this.namespace = namespace;
    }

    public MessageType registerS2C(String id, MessageDecoder<BaseS2CMessage> decoder) {
        MessageType messageType = new MessageType(this, new class_2960(this.namespace, id), NetworkManager.s2c());
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.NetworkReceiver receiver = decoder.createReceiver();
            NetworkManager.registerReceiver(NetworkManager.s2c(), messageType.getId(), receiver);
        }
        return messageType;
    }

    public MessageType registerC2S(String id, MessageDecoder<BaseC2SMessage> decoder) {
        MessageType messageType = new MessageType(this, new class_2960(this.namespace, id), NetworkManager.c2s());
        NetworkManager.NetworkReceiver receiver = decoder.createReceiver();
        NetworkManager.registerReceiver(NetworkManager.c2s(), messageType.getId(), receiver);
        return messageType;
    }
}

