/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.simplenetworking;

import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.pepperbell.simplenetworking.C2SPacket;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SimpleChannel {
    private static final Logger LOGGER = LogManager.getLogger((String)"Simple Networking API");
    private final class_2960 channelName;
    private final Map<Class<? extends C2SPacket>, Integer> c2sIdMap = new HashMap<Class<? extends C2SPacket>, Integer>();
    private final Map<Class<? extends S2CPacket>, Integer> s2cIdMap = new HashMap<Class<? extends S2CPacket>, Integer>();
    private final Int2ObjectMap<Function<class_2540, ? extends C2SPacket>> c2sDecoderMap = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Function<class_2540, ? extends S2CPacket>> s2cDecoderMap = new Int2ObjectOpenHashMap();
    private C2SHandler c2sHandler;
    private S2CHandler s2cHandler;

    public SimpleChannel(class_2960 channelName) {
        this.channelName = channelName;
    }

    public void initServerListener() {
        this.c2sHandler = new C2SHandler();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.channelName, (ServerPlayNetworking.PlayChannelHandler)this.c2sHandler);
    }

    @Environment(value=EnvType.CLIENT)
    public void initClientListener() {
        this.s2cHandler = new S2CHandler();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channelName, (ClientPlayNetworking.PlayChannelHandler)this.s2cHandler);
    }

    public <T extends C2SPacket> void registerC2SPacket(Class<T> clazz, int id, Function<class_2540, T> decoder) {
        this.c2sIdMap.put(clazz, id);
        this.c2sDecoderMap.put(id, decoder);
    }

    public <T extends C2SPacket> void registerC2SPacket(Class<T> clazz, int id) {
        try {
            Constructor ctor = clazz.getDeclaredConstructor(class_2540.class);
            ctor.setAccessible(true);
            this.registerC2SPacket(clazz, id, buf -> {
                try {
                    return (C2SPacket)ctor.newInstance(buf);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not register C2S packet for channel '" + this.channelName + "' with id " + id, (Throwable)e);
        }
    }

    public <T extends S2CPacket> void registerS2CPacket(Class<T> clazz, int id, Function<class_2540, T> decoder) {
        this.s2cIdMap.put(clazz, id);
        this.s2cDecoderMap.put(id, decoder);
    }

    public <T extends S2CPacket> void registerS2CPacket(Class<T> clazz, int id) {
        try {
            Constructor ctor = clazz.getDeclaredConstructor(class_2540.class);
            ctor.setAccessible(true);
            this.registerS2CPacket(clazz, id, buf -> {
                try {
                    return (S2CPacket)ctor.newInstance(buf);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not register S2C packet for channel '" + this.channelName + "' with id " + id, (Throwable)e);
        }
    }

    @Nullable
    public class_2540 createBuf(C2SPacket packet) {
        Integer id = this.c2sIdMap.get(packet.getClass());
        if (id == null) {
            LOGGER.error("Could not get id for C2S packet '" + packet.toString() + "' in channel '" + this.channelName + "'");
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(id.intValue());
        packet.encode(buf);
        return buf;
    }

    @Nullable
    public class_2540 createBuf(S2CPacket packet) {
        Integer id = this.s2cIdMap.get(packet.getClass());
        if (id == null) {
            LOGGER.error("Could not get id for S2C packet '" + packet.toString() + "' in channel '" + this.channelName + "'");
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(id.intValue());
        packet.encode(buf);
        return buf;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2596<?> createVanillaPacket(C2SPacket packet) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return null;
        }
        return ClientPlayNetworking.createC2SPacket((class_2960)this.channelName, (class_2540)buf);
    }

    @Nullable
    public class_2596<?> createVanillaPacket(S2CPacket packet) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return null;
        }
        return ServerPlayNetworking.createS2CPacket((class_2960)this.channelName, (class_2540)buf);
    }

    public void send(C2SPacket packet, PacketSender packetSender) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return;
        }
        packetSender.sendPacket(this.channelName, buf);
    }

    public void send(S2CPacket packet, PacketSender packetSender) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return;
        }
        packetSender.sendPacket(this.channelName, buf);
    }

    @Environment(value=EnvType.CLIENT)
    public void sendToServer(C2SPacket packet) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return;
        }
        ClientPlayNetworking.send((class_2960)this.channelName, (class_2540)buf);
    }

    public void sendToClient(S2CPacket packet, class_3222 player) {
        class_2540 buf = this.createBuf(packet);
        if (buf == null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelName, (class_2540)buf);
    }

    public void sendToClients(S2CPacket packet, Iterable<class_3222> players) {
        class_2596<?> vanillaPacket = this.createVanillaPacket(packet);
        if (vanillaPacket == null) {
            return;
        }
        for (class_3222 player : players) {
            ServerPlayNetworking.getSender((class_3222)player).sendPacket(vanillaPacket);
        }
    }

    public void sendToClientsInServer(S2CPacket packet, MinecraftServer server) {
        this.sendToClients(packet, PlayerLookup.all((MinecraftServer)server));
    }

    public void sendToClientsInCurrentServer(S2CPacket packet) {
        this.sendToClientsInServer(packet, ServerLifecycleHooks.getCurrentServer());
    }

    public void sendToClientsInWorld(S2CPacket packet, class_3218 world) {
        this.sendToClients(packet, PlayerLookup.world((class_3218)world));
    }

    public void sendToClientsTracking(S2CPacket packet, class_3218 world, class_2338 pos) {
        this.sendToClients(packet, PlayerLookup.tracking((class_3218)world, (class_2338)pos));
    }

    public void sendToClientsTracking(S2CPacket packet, class_3218 world, class_1923 pos) {
        this.sendToClients(packet, PlayerLookup.tracking((class_3218)world, (class_1923)pos));
    }

    public void sendToClientsTracking(S2CPacket packet, class_1297 entity) {
        this.sendToClients(packet, PlayerLookup.tracking((class_1297)entity));
    }

    public void sendToClientsTracking(S2CPacket packet, class_2586 blockEntity) {
        this.sendToClients(packet, PlayerLookup.tracking((class_2586)blockEntity));
    }

    public void sendToClientsTrackingAndSelf(S2CPacket packet, class_1297 entity) {
        class_3222 player;
        ArrayList<class_3222> clients = PlayerLookup.tracking((class_1297)entity);
        if (entity instanceof class_3222 && !clients.contains(player = (class_3222)entity)) {
            clients = new ArrayList<class_3222>(clients);
            clients.add(player);
        }
        this.sendToClients(packet, (Iterable<class_3222>)clients);
    }

    public void sendToClientsAround(S2CPacket packet, class_3218 world, class_243 pos, double radius) {
        this.sendToClients(packet, PlayerLookup.around((class_3218)world, (class_243)pos, (double)radius));
    }

    public void sendToClientsAround(S2CPacket packet, class_3218 world, class_2382 pos, double radius) {
        this.sendToClients(packet, PlayerLookup.around((class_3218)world, (class_2382)pos, (double)radius));
    }

    public class_2960 getChannelName() {
        return this.channelName;
    }

    private class C2SHandler
    implements ServerPlayNetworking.PlayChannelHandler {
        private C2SHandler() {
        }

        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            C2SPacket packet;
            int id = buf.method_10816();
            try {
                packet = (C2SPacket)((Function)SimpleChannel.this.c2sDecoderMap.get(id)).apply(buf);
            }
            catch (Exception e) {
                LOGGER.error("Could not create C2S packet in channel '" + SimpleChannel.this.channelName + "' with id " + id, (Throwable)e);
                return;
            }
            packet.handle(server, player, handler, responseSender, SimpleChannel.this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class S2CHandler
    implements ClientPlayNetworking.PlayChannelHandler {
        private S2CHandler() {
        }

        public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            S2CPacket packet;
            int id = buf.method_10816();
            try {
                packet = (S2CPacket)((Function)SimpleChannel.this.s2cDecoderMap.get(id)).apply(buf);
            }
            catch (Exception e) {
                LOGGER.error("Could not create S2C packet in channel '" + SimpleChannel.this.channelName + "' with id " + id, (Throwable)e);
                return;
            }
            packet.handle(client, handler, responseSender, SimpleChannel.this);
        }
    }
}

