/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util.client;

import io.github.fabricators_of_create.porting_lib.util.LightUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2382;
import net.minecraft.class_290;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.lwjgl.system.MemoryStack;

public class VertexUtils {
    public static void putBulkData(class_4588 builder, class_4587.class_4665 poseStack, class_777 bakedQuad, float red, float green, float blue, int packedLight, int packedOverlay, boolean readExistingColor) {
        VertexUtils.putBulkData(builder, poseStack, bakedQuad, red, green, blue, 1.0f, packedLight, packedOverlay, readExistingColor);
    }

    public static void putBulkData(class_4588 builder, class_4587.class_4665 pose, class_777 bakedQuad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        VertexUtils.putBulkData(builder, pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, false);
    }

    public static void putBulkData(class_4588 builder, class_4587.class_4665 pose, class_777 bakedQuad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, boolean readExistingColor) {
        VertexUtils.putBulkData(builder, pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, readExistingColor);
    }

    public static void putBulkData(class_4588 builder, class_4587.class_4665 pose, class_777 bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay, boolean readExistingColor) {
        int[] aint = bakedQuad.method_3357();
        class_2382 faceNormal = bakedQuad.method_3358().method_10163();
        class_1160 normal = new class_1160((float)faceNormal.method_10263(), (float)faceNormal.method_10264(), (float)faceNormal.method_10260());
        class_1159 matrix4f = pose.method_23761();
        normal.method_23215(pose.method_23762());
        int intSize = class_290.field_1590.method_1359();
        int vertexCount = aint.length / intSize;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(class_290.field_1590.method_1362());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                float ca;
                float cb;
                float cg;
                float cr;
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, v * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (readExistingColor) {
                    float r = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float g = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float b = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    float a = (float)(bytebuffer.get(15) & 0xFF) / 255.0f;
                    cr = r * baseBrightness[v] * red;
                    cg = g * baseBrightness[v] * green;
                    cb = b * baseBrightness[v] * blue;
                    ca = a * alpha;
                } else {
                    cr = baseBrightness[v] * red;
                    cg = baseBrightness[v] * green;
                    cb = baseBrightness[v] * blue;
                    ca = alpha;
                }
                int lightmapCoord = VertexUtils.applyBakedLighting(lightmap[v], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                class_1162 pos = new class_1162(f, f1, f2, 1.0f);
                pos.method_22674(matrix4f);
                VertexUtils.applyBakedNormals(normal, bytebuffer, pose.method_23762());
                builder.method_23919(pos.method_4953(), pos.method_4956(), pos.method_4957(), cr, cg, cb, ca, f9, f10, packedOverlay, lightmapCoord, normal.method_4943(), normal.method_4945(), normal.method_4947());
            }
        }
    }

    public static int applyBakedLighting(int packedLight, ByteBuffer data) {
        int bl = packedLight & 0xFFFF;
        int sl = packedLight >> 16 & 0xFFFF;
        int offset = LightUtil.getLightOffset(0) * 4;
        int blBaked = Short.toUnsignedInt(data.getShort(offset));
        int slBaked = Short.toUnsignedInt(data.getShort(offset + 2));
        bl = Math.max(bl, blBaked);
        sl = Math.max(sl, slBaked);
        return bl | sl << 16;
    }

    public static void applyBakedNormals(class_1160 generated, ByteBuffer data, class_4581 normalTransform) {
        byte nx = data.get(28);
        byte ny = data.get(29);
        byte nz = data.get(30);
        if (nx != 0 || ny != 0 || nz != 0) {
            generated.method_4949((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.method_23215(normalTransform);
        }
    }
}

