/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_3532;
import net.minecraft.class_4590;
import net.minecraft.class_804;

public final class TransformationHelper {
    private static final double THRESHOLD = 0.9995;

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public static class_4590 toTransformation(class_804 transform) {
        if (transform.equals((Object)class_804.field_4284)) {
            return class_4590.method_22931();
        }
        return new class_4590(transform.field_4286, TransformationHelper.quatFromXYZ(transform.field_4287, true), transform.field_4285, null);
    }

    public static class_1158 quatFromXYZ(class_1160 xyz, boolean degrees) {
        return new class_1158(xyz.method_4943(), xyz.method_4945(), xyz.method_4947(), degrees);
    }

    public static class_1158 quatFromXYZ(float[] xyz, boolean degrees) {
        return new class_1158(xyz[0], xyz[1], xyz[2], degrees);
    }

    public static class_1158 makeQuaternion(float[] values) {
        return new class_1158(values[0], values[1], values[2], values[3]);
    }

    public static class_1160 lerp(class_1160 from, class_1160 to, float progress) {
        class_1160 res = from.method_23850();
        res.method_23847(to, progress);
        return res;
    }

    public static class_1158 slerp(class_1158 v0, class_1158 v1, float t) {
        float dot = v0.method_4921() * v1.method_4921() + v0.method_4922() * v1.method_4922() + v0.method_4923() * v1.method_4923() + v0.method_4924() * v1.method_4924();
        if (dot < 0.0f) {
            v1 = new class_1158(-v1.method_4921(), -v1.method_4922(), -v1.method_4923(), -v1.method_4924());
            dot = -dot;
        }
        if ((double)dot > 0.9995) {
            float x = class_3532.method_16439((float)t, (float)v0.method_4921(), (float)v1.method_4921());
            float y = class_3532.method_16439((float)t, (float)v0.method_4922(), (float)v1.method_4922());
            float z = class_3532.method_16439((float)t, (float)v0.method_4923(), (float)v1.method_4923());
            float w = class_3532.method_16439((float)t, (float)v0.method_4924(), (float)v1.method_4924());
            return new class_1158(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = class_3532.method_15374((float)angle0t);
        float sin01 = class_3532.method_15374((float)angle01);
        float sin1t = class_3532.method_15374((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new class_1158(s0 * v0.method_4921() + s1 * v1.method_4921(), s0 * v0.method_4922() + s1 * v1.method_4922(), s0 * v0.method_4923() + s1 * v1.method_4923(), s0 * v0.method_4924() + s1 * v1.method_4924());
    }

    public static class_4590 slerp(class_4590 one, class_4590 that, float progress) {
        return new class_4590(TransformationHelper.lerp(one.method_35865(), that.method_35865(), progress), TransformationHelper.slerp(one.method_22937(), that.method_22937(), progress), TransformationHelper.lerp(one.method_35866(), that.method_35866(), progress), TransformationHelper.slerp(one.method_35867(), that.method_35867(), progress));
    }

    public static boolean epsilonEquals(class_1162 v1, class_1162 v2, float epsilon) {
        return class_3532.method_15379((float)(v1.method_4953() - v2.method_4953())) < epsilon && class_3532.method_15379((float)(v1.method_4956() - v2.method_4956())) < epsilon && class_3532.method_15379((float)(v1.method_4957() - v2.method_4957())) < epsilon && class_3532.method_15379((float)(v1.method_23853() - v2.method_23853())) < epsilon;
    }

    public static class Deserializer
    implements JsonDeserializer<class_4590> {
        private static final class_1160 ORIGIN_CORNER = new class_1160();
        private static final class_1160 ORIGIN_OPPOSING_CORNER = new class_1160(1.0f, 1.0f, 1.0f);
        private static final class_1160 ORIGIN_CENTER = new class_1160(0.5f, 0.5f, 0.5f);

        public class_4590 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            float[] vec;
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return class_4590.method_22931();
                }
                throw new JsonParseException("TRSR: unknown default string: " + transform);
            }
            if (json.isJsonArray()) {
                return new class_4590(Deserializer.parseMatrix(json));
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("TRSR: expected array or object, got: " + json);
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("matrix")) {
                class_4590 ret = new class_4590(Deserializer.parseMatrix(obj.get("matrix")));
                obj.remove("matrix");
                if (obj.entrySet().size() != 0) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            class_1160 translation = null;
            class_1158 leftRot = null;
            class_1160 scale = null;
            class_1158 rightRot = null;
            class_1160 origin = ORIGIN_OPPOSING_CORNER;
            if (obj.has("translation")) {
                vec = Deserializer.parseFloatArray(obj.get("translation"), 3, "Translation");
                translation = new class_1160(vec[0], vec[1], vec[2]);
                obj.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = Deserializer.parseRotation(obj.get("rotation"));
                obj.remove("rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new class_1160(s, s, s);
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + obj.get("scale"));
                    }
                } else {
                    vec = Deserializer.parseFloatArray(obj.get("scale"), 3, "Scale");
                    scale = new class_1160(vec[0], vec[1], vec[2]);
                }
                obj.remove("scale");
            }
            if (obj.has("post-rotation")) {
                rightRot = Deserializer.parseRotation(obj.get("post-rotation"));
                obj.remove("post-rotation");
            }
            if (obj.has("origin")) {
                origin = Deserializer.parseOrigin(obj);
                obj.remove("origin");
            }
            if (!obj.entrySet().isEmpty()) {
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
            }
            class_4590 matrix = new class_4590(translation, leftRot, scale, rightRot);
            if (!ORIGIN_CENTER.equals((Object)origin)) {
                class_1160 originFromCenter = origin.method_23850();
                originFromCenter.method_4944(ORIGIN_CENTER);
                matrix = matrix.applyOrigin(originFromCenter);
            }
            return matrix;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static class_1160 parseOrigin(JsonObject obj) {
            class_1160 origin = null;
            JsonElement originElement = obj.get("origin");
            if (originElement.isJsonArray()) {
                float[] vec = Deserializer.parseFloatArray(originElement, 3, "Origin");
                return new class_1160(vec[0], vec[1], vec[2]);
            }
            if (!originElement.isJsonPrimitive()) throw new JsonParseException("Origin: expected an array or one of 'center', 'corner', 'opposing-corner'");
            String originString = originElement.getAsString();
            if ("center".equals(originString)) {
                return ORIGIN_CENTER;
            }
            if ("corner".equals(originString)) {
                return ORIGIN_CORNER;
            }
            if (!"opposing-corner".equals(originString)) throw new JsonParseException("Origin: expected one of 'center', 'corner', 'opposing-corner'");
            return ORIGIN_OPPOSING_CORNER;
        }

        public static class_1159 parseMatrix(JsonElement e) {
            if (!e.isJsonArray()) {
                throw new JsonParseException("Matrix: expected an array, got: " + e);
            }
            JsonArray m = e.getAsJsonArray();
            if (m.size() != 3) {
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m.size());
            }
            float[] values = new float[16];
            for (int i = 0; i < 3; ++i) {
                if (!m.get(i).isJsonArray()) {
                    throw new JsonParseException("Matrix row: expected an array, got: " + m.get(i));
                }
                JsonArray r = m.get(i).getAsJsonArray();
                if (r.size() != 4) {
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                }
                for (int j = 0; j < 4; ++j) {
                    try {
                        values[j * 4 + i] = r.get(j).getAsNumber().floatValue();
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + r.get(j));
                    }
                }
            }
            class_1159 matrix4f = new class_1159();
            matrix4f.fromFloatArray(values);
            return matrix4f;
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray()) {
                throw new JsonParseException(prefix + ": expected an array, got: " + e);
            }
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length) {
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            }
            float[] ret = new float[length];
            for (int i = 0; i < length; ++i) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + t.get(i));
                }
            }
            return ret;
        }

        public static class_1158 parseAxisRotation(JsonElement e) {
            class_1158 ret;
            block7: {
                if (!e.isJsonObject()) {
                    throw new JsonParseException("Axis rotation: object expected, got: " + e);
                }
                JsonObject obj = e.getAsJsonObject();
                if (obj.entrySet().size() != 1) {
                    throw new JsonParseException("Axis rotation: expected single axis object, got: " + e);
                }
                Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
                try {
                    if (((String)entry.getKey()).equals("x")) {
                        ret = class_1160.field_20703.method_23214(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("y")) {
                        ret = class_1160.field_20705.method_23214(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("z")) {
                        ret = class_1160.field_20707.method_23214(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    throw new JsonParseException("Axis rotation: expected single axis key, got: " + (String)entry.getKey());
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException("Axis rotation value: expected number, got: " + entry.getValue());
                }
            }
            return ret;
        }

        public static class_1158 parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    class_1158 ret = class_1158.field_21493.method_23695();
                    for (JsonElement a : e.getAsJsonArray()) {
                        ret.method_4925(Deserializer.parseAxisRotation(a));
                    }
                    return ret;
                }
                if (e.isJsonArray()) {
                    JsonArray array = e.getAsJsonArray();
                    if (array.size() == 3) {
                        return TransformationHelper.quatFromXYZ(Deserializer.parseFloatArray(e, 3, "Rotation"), true);
                    }
                    return TransformationHelper.makeQuaternion(Deserializer.parseFloatArray(e, 4, "Rotation"));
                }
                throw new JsonParseException("Rotation: expected array or object, got: " + e);
            }
            if (e.isJsonObject()) {
                return Deserializer.parseAxisRotation(e);
            }
            throw new JsonParseException("Rotation: expected array or object, got: " + e);
        }
    }
}

