/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import io.github.fabricators_of_create.porting_lib.event.common.ModsLoadedCallback;
import io.github.fabricators_of_create.porting_lib.extensions.BlockItemExtensions;
import io.github.fabricators_of_create.porting_lib.util.FluidAttributes;
import io.github.fabricators_of_create.porting_lib.util.FluidVariantFluidAttributesHandler;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;

public class PortingHooks {
    public static int onBlockBreakEvent(class_1937 world, class_1934 gameType, class_3222 entityPlayer, class_2338 pos) {
        boolean preCancelEvent = false;
        class_1799 itemstack = entityPlayer.method_6047();
        if (!itemstack.method_7960() && !itemstack.method_7909().method_7885(world.method_8320(pos), world, pos, (class_1657)entityPlayer)) {
            preCancelEvent = true;
        }
        if (gameType.method_8387()) {
            if (gameType == class_1934.field_9219) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.method_7294() || !itemstack.method_7960() && itemstack.method_7940(world.method_30349().method_30530(class_2378.field_25105), new class_2694((class_4538)world, pos, false)))) {
                preCancelEvent = true;
            }
        }
        if (world.method_8321(pos) == null) {
            entityPlayer.field_13987.method_14364((class_2596)new class_2626(pos, world.method_8316(pos).method_15759()));
        }
        class_2680 state = world.method_8320(pos);
        BlockEvents.BreakEvent event = new BlockEvents.BreakEvent(world, pos, state, (class_1657)entityPlayer);
        event.setCanceled(preCancelEvent);
        event.sendEvent();
        if (event.isCanceled()) {
            class_2596 pkt;
            entityPlayer.field_13987.method_14364((class_2596)new class_2626((class_1922)world, pos));
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null && (pkt = blockEntity.method_38235()) != null) {
                entityPlayer.field_13987.method_14364(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static void init() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    world.getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    world.getPartEntityMap().remove(part.method_5628());
                }
            }
        });
        RegistryEntryRemovedCallback.event((class_2378)class_2378.field_11142).register((rawId, id, item) -> {
            if (item instanceof BlockItemExtensions) {
                BlockItemExtensions blockItem = (BlockItemExtensions)item;
                blockItem.removeFromBlockToItemMap(class_1792.field_8003, (class_1792)item);
            }
        });
        ModsLoadedCallback.EVENT.register(envType -> class_2378.field_11154.forEach(fluid -> {
            if (envType == EnvType.SERVER && FluidVariantAttributes.getHandler((class_3611)fluid) == null) {
                FluidVariantAttributes.register((class_3611)fluid, (FluidVariantAttributeHandler)new FluidVariantFluidAttributesHandler(fluid.getAttributes()));
            }
        }));
    }

    public static FluidAttributes getFluidAttributesFromVariant(class_3611 fluid) {
        if (!fluid.method_15793(fluid.method_15785()) && fluid instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)fluid;
            return flowingFluid.method_15751().getAttributes();
        }
        if (!fluid.method_15793(fluid.method_15785()) && fluid != class_3612.field_15906) {
            return class_3612.field_15910.getAttributes();
        }
        FluidVariantAttributeHandler handler = FluidVariantAttributes.getHandler((class_3611)fluid);
        if (handler == null) {
            handler = FluidVariantAttributes.getHandler((class_3611)class_3612.field_15910);
        }
        FluidVariant variant = FluidVariant.of((class_3611)fluid);
        class_2960 stillTexture = null;
        class_2960 flowingTexture = null;
        class_2960 overlayTexture = null;
        int color = -1;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)variant);
            stillTexture = sprites[0] == null ? SimpleFluidRenderHandler.WATER_STILL : sprites[0].method_4598();
            class_2960 class_29602 = flowingTexture = sprites[1] == null ? SimpleFluidRenderHandler.WATER_FLOWING : sprites[1].method_4598();
            if (sprites.length == 3) {
                overlayTexture = sprites[2] == null ? SimpleFluidRenderHandler.WATER_OVERLAY : sprites[2].method_4598();
            }
            color = FluidVariantRendering.getColor((FluidVariant)variant);
        }
        FluidAttributes.Builder builder = FluidAttributes.builder(stillTexture, flowingTexture);
        builder.sound(handler.getFillSound(variant).orElse(null), handler.getEmptySound(variant).orElse(null));
        builder.overlay(overlayTexture);
        builder.viscosity(handler.getViscosity(variant, null));
        builder.luminosity(handler.getLuminance(variant));
        builder.temperature(handler.getTemperature(variant));
        if (handler.isLighterThanAir(variant)) {
            builder.gaseous();
        }
        builder.color(color);
        return builder.build(fluid);
    }

    public static int getLootingLevel(class_1297 target, @Nullable class_1297 killer, @Nullable class_1282 cause) {
        if (killer instanceof class_1309) {
            return class_1890.method_8226((class_1309)((class_1309)killer));
        }
        return 0;
    }
}

