/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1163;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3614;

@Deprecated(forRemoval=true)
public class FluidAttributes {
    public static final long BUCKET_VOLUME = 81000L;
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    @Nullable
    private final class_2960 overlayTexture;
    private final class_3414 fillSound;
    private final class_3414 emptySound;
    private final int luminosity;
    private final int density;
    private final int temperature;
    private final int viscosity;
    private final boolean isGaseous;
    private final class_1814 rarity;
    private final int color;
    private final String translationKey;

    protected FluidAttributes(Builder builder, class_3611 fluid) {
        this.translationKey = builder.translationKey != null ? builder.translationKey : class_156.method_646((String)"fluid", (class_2960)class_2378.field_11154.method_10221((Object)fluid));
        this.stillTexture = builder.stillTexture;
        this.flowingTexture = builder.flowingTexture;
        this.overlayTexture = builder.overlayTexture;
        this.color = builder.color;
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
        this.luminosity = builder.luminosity;
        this.temperature = builder.temperature;
        this.viscosity = builder.viscosity;
        this.density = builder.density;
        this.isGaseous = builder.isGaseous;
        this.rarity = builder.rarity;
    }

    public static Builder builder(class_2960 stillTexture, class_2960 flowingTexture) {
        return new Builder(stillTexture, flowingTexture, FluidAttributes::new);
    }

    public class_1799 getBucket(FluidStack stack) {
        return new class_1799((class_1935)stack.getFluid().method_15774());
    }

    public class_2680 getBlock(class_1920 reader, class_2338 pos, class_3610 state) {
        return state.method_15759();
    }

    public class_3610 getStateForPlacement(class_1920 reader, class_2338 pos, FluidStack state) {
        return state.getFluid().method_15785();
    }

    public final boolean canBePlacedInWorld(class_1920 reader, class_2338 pos, class_3610 state) {
        return !this.getBlock(reader, pos, state).method_26215();
    }

    public final boolean canBePlacedInWorld(class_1920 reader, class_2338 pos, FluidStack state) {
        return !this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, state)).method_26215();
    }

    public final boolean isLighterThanAir() {
        return this.density <= 0;
    }

    public boolean doesVaporize(class_1920 reader, class_2338 pos, FluidStack fluidStack) {
        class_2680 blockstate = this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, fluidStack));
        if (blockstate == null) {
            return false;
        }
        return blockstate.method_26207() == class_3614.field_15920;
    }

    public void vaporize(@Nullable class_1657 player, class_1937 worldIn, class_2338 pos, FluidStack fluidStack) {
        worldIn.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (worldIn.field_9229.nextFloat() - worldIn.field_9229.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            worldIn.method_8494((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public class_2561 getDisplayName(FluidStack stack) {
        return new class_2588(this.getTranslationKey());
    }

    public String getTranslationKey(FluidStack stack) {
        return this.getTranslationKey();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public class_1814 getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return this.color;
    }

    public class_2960 getStillTexture() {
        return this.stillTexture;
    }

    public class_2960 getFlowingTexture() {
        return this.flowingTexture;
    }

    @Nullable
    public class_2960 getOverlayTexture() {
        return this.overlayTexture;
    }

    public class_3414 getFillSound() {
        return this.fillSound;
    }

    public class_3414 getEmptySound() {
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public class_1814 getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public class_2960 getStillTexture(FluidStack stack) {
        return this.getStillTexture();
    }

    public class_2960 getFlowingTexture(FluidStack stack) {
        return this.getFlowingTexture();
    }

    public class_3414 getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public class_3414 getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(class_1920 world, class_2338 pos) {
        return this.getLuminosity();
    }

    public int getDensity(class_1920 world, class_2338 pos) {
        return this.getDensity();
    }

    public int getTemperature(class_1920 world, class_2338 pos) {
        return this.getTemperature();
    }

    public int getViscosity(class_1920 world, class_2338 pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(class_1920 world, class_2338 pos) {
        return this.isGaseous();
    }

    public class_1814 getRarity(class_1920 world, class_2338 pos) {
        return this.getRarity();
    }

    public int getColor(class_1920 world, class_2338 pos) {
        return this.getColor();
    }

    public class_2960 getStillTexture(class_1920 world, class_2338 pos) {
        return this.getStillTexture();
    }

    public class_2960 getFlowingTexture(class_1920 world, class_2338 pos) {
        return this.getFlowingTexture();
    }

    public class_3414 getFillSound(class_1920 world, class_2338 pos) {
        return this.getFillSound();
    }

    public class_3414 getEmptySound(class_1920 world, class_2338 pos) {
        return this.getEmptySound();
    }

    public Stream<class_2960> getTextures() {
        if (this.overlayTexture != null) {
            return Stream.of(this.stillTexture, this.flowingTexture, this.overlayTexture);
        }
        return Stream.of(this.stillTexture, this.flowingTexture);
    }

    public static class Builder {
        private final class_2960 stillTexture;
        private final class_2960 flowingTexture;
        private class_2960 overlayTexture;
        private int color = -1;
        private String translationKey;
        private class_3414 fillSound;
        private class_3414 emptySound;
        private int luminosity = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private boolean isGaseous;
        private class_1814 rarity = class_1814.field_8906;
        private final BiFunction<Builder, class_3611, FluidAttributes> factory;

        protected Builder(class_2960 stillTexture, class_2960 flowingTexture, BiFunction<Builder, class_3611, FluidAttributes> factory) {
            this.factory = factory;
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public final Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public final Builder color(int color) {
            this.color = color;
            return this;
        }

        public final Builder overlay(class_2960 texture) {
            this.overlayTexture = texture;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder density(int density) {
            this.density = density;
            return this;
        }

        public final Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public final Builder gaseous() {
            this.isGaseous = true;
            return this;
        }

        public final Builder rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }

        public final Builder sound(class_3414 sound) {
            this.fillSound = this.emptySound = sound;
            return this;
        }

        public final Builder sound(class_3414 fillSound, class_3414 emptySound) {
            this.fillSound = fillSound;
            this.emptySound = emptySound;
            return this;
        }

        public FluidAttributes build(class_3611 fluid) {
            return this.factory.apply(this, fluid);
        }
    }

    public static class Water
    extends FluidAttributes {
        protected Water(Builder builder, class_3611 fluid) {
            super(builder, fluid);
        }

        public static Builder builder(class_2960 stillTexture, class_2960 flowingTexture) {
            return new Builder(stillTexture, flowingTexture, Water::new);
        }

        @Override
        public int getColor(class_1920 world, class_2338 pos) {
            return class_1163.method_4961((class_1920)world, (class_2338)pos) | 0xFF000000;
        }
    }
}

