/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.cache;

import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.cache.ClientBlockApiCache;
import io.github.fabricators_of_create.porting_lib.transfer.cache.EmptyFluidLookupCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class ClientFluidLookupCache
implements BlockApiCache<Storage<FluidVariant>, class_2350>,
ClientBlockApiCache {
    private final class_638 world;
    private final class_2338 pos;
    private boolean blockEntityCacheValid = false;
    private class_2586 cachedBlockEntity = null;
    private class_2680 lastState = null;

    public static BlockApiCache<Storage<FluidVariant>, class_2350> get(class_1937 level, class_2338 pos) {
        if (level instanceof class_638) {
            class_638 c = (class_638)level;
            return new ClientFluidLookupCache(c, pos);
        }
        return EmptyFluidLookupCache.INSTANCE;
    }

    public ClientFluidLookupCache(class_638 world, class_2338 pos) {
        world.port_lib$registerCache(pos, this);
        this.world = world;
        this.pos = pos.method_10062();
    }

    @Override
    public void invalidate() {
        this.blockEntityCacheValid = false;
        this.cachedBlockEntity = null;
        this.lastState = null;
    }

    @Nullable
    public Storage<FluidVariant> find(@Nullable class_2680 state, @Nullable class_2350 context) {
        this.getBlockEntity();
        if (state == null) {
            state = this.cachedBlockEntity != null ? this.cachedBlockEntity.method_11010() : this.world.method_8320(this.pos);
        }
        if (this.lastState != state) {
            this.lastState = state;
        }
        if (this.cachedBlockEntity == null) {
            return null;
        }
        return TransferUtil.getFluidStorage(this.cachedBlockEntity, context);
    }

    @Nullable
    public class_2586 getBlockEntity() {
        if (!this.blockEntityCacheValid) {
            this.cachedBlockEntity = this.world.method_8321(this.pos);
            this.blockEntityCacheValid = true;
        }
        return this.cachedBlockEntity;
    }

    public BlockApiLookup<Storage<FluidVariant>, class_2350> getLookup() {
        return FluidStorage.SIDED;
    }

    public class_3218 getWorld() {
        return null;
    }

    public class_2338 getPos() {
        return this.pos;
    }
}

