/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.obj.LineReader;
import io.github.fabricators_of_create.porting_lib.model.obj.MaterialLibrary;
import io.github.fabricators_of_create.porting_lib.model.obj.OBJModel;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class OBJLoader
implements IModelLoader<OBJModel> {
    public static OBJLoader INSTANCE = new OBJLoader();
    private final Map<OBJModel.ModelSettings, OBJModel> modelCache = Maps.newHashMap();
    private final Map<class_2960, MaterialLibrary> materialCache = Maps.newHashMap();
    private class_3300 manager = class_310.method_1551().method_1478();

    public void method_14491(class_3300 resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public OBJModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = class_3518.method_15258((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = class_3518.method_15258((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = class_3518.method_15258((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = class_3518.method_15258((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? class_3518.method_15265((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new OBJModel.ModelSettings(new class_2960(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public OBJModel loadModel(OBJModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            try (class_3298 resource = this.manager.method_14486(settings.modelLocation());){
                OBJModel oBJModel;
                try (LineReader rdr = new LineReader(resource);){
                    oBJModel = new OBJModel(rdr, settings);
                }
                return oBJModel;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }

    public MaterialLibrary loadMaterialLibrary(class_2960 materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            try (class_3298 resource = this.manager.method_14486(location);){
                MaterialLibrary materialLibrary;
                try (LineReader rdr = new LineReader(resource);){
                    materialLibrary = new MaterialLibrary(rdr);
                }
                return materialLibrary;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ material library", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ material library", e);
            }
        });
    }
}

