/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.render.TransformTypeDependentItemBakedModel;
import io.github.fabricators_of_create.porting_lib.util.TransformationHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class PerspectiveMapWrapper
implements class_1087,
TransformTypeDependentItemBakedModel {
    private final class_1087 parent;
    private final ImmutableMap<class_809.class_811, class_4590> transforms;
    private final OverrideListWrapper overrides = new OverrideListWrapper();

    public PerspectiveMapWrapper(class_1087 parent, ImmutableMap<class_809.class_811, class_4590> transforms) {
        this.parent = parent;
        this.transforms = transforms;
    }

    public PerspectiveMapWrapper(class_1087 parent, class_3665 state) {
        this(parent, PerspectiveMapWrapper.getTransforms(state));
    }

    public static ImmutableMap<class_809.class_811, class_4590> getTransforms(class_3665 state) {
        EnumMap<class_809.class_811, class_4590> map = new EnumMap<class_809.class_811, class_4590>(class_809.class_811.class);
        for (class_809.class_811 type : class_809.class_811.values()) {
            class_4590 tr = state.getPartTransformation((Object)type);
            if (tr.isIdentity()) continue;
            map.put(type, tr);
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<class_809.class_811, class_4590> getTransformsWithFallback(class_3665 state, class_809 transforms) {
        EnumMap<class_809.class_811, class_4590> map = new EnumMap<class_809.class_811, class_4590>(class_809.class_811.class);
        for (class_809.class_811 type : class_809.class_811.values()) {
            class_4590 tr = state.getPartTransformation((Object)type);
            if (!tr.isIdentity()) {
                map.put(type, tr);
                continue;
            }
            if (!transforms.method_3501(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.method_3503(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<class_809.class_811, class_4590> getTransforms(class_809 transforms) {
        EnumMap<class_809.class_811, class_4590> map = new EnumMap<class_809.class_811, class_4590>(class_809.class_811.class);
        for (class_809.class_811 type : class_809.class_811.values()) {
            if (!transforms.method_3501(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.method_3503(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static class_1087 handlePerspective(class_1087 model, ImmutableMap<class_809.class_811, class_4590> transforms, class_809.class_811 cameraTransformType, class_4587 mat) {
        class_4590 tr = (class_4590)transforms.getOrDefault((Object)cameraTransformType, (Object)class_4590.method_22931());
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public static class_1087 handlePerspective(class_1087 model, class_3665 state, class_809.class_811 cameraTransformType, class_4587 mat) {
        class_4590 tr = state.getPartTransformation((Object)cameraTransformType);
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public boolean method_4708() {
        return this.parent.method_4708();
    }

    public boolean method_4712() {
        return this.parent.method_4712();
    }

    public boolean method_24304() {
        return this.parent.method_24304();
    }

    public boolean method_4713() {
        return this.parent.method_4713();
    }

    public class_1058 method_4711() {
        return this.parent.method_4711();
    }

    public class_809 method_4709() {
        return this.parent.method_4709();
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, Random rand) {
        return this.parent.method_4707(state, side, rand);
    }

    public class_806 method_4710() {
        return this.overrides;
    }

    @Override
    public class_1087 handlePerspective(class_809.class_811 cameraTransformType, class_4587 poseStack) {
        return PerspectiveMapWrapper.handlePerspective((class_1087)this, this.transforms, cameraTransformType, poseStack);
    }

    private class OverrideListWrapper
    extends class_806 {
        @Nullable
        public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 worldIn, @Nullable class_1309 entityIn, int seed) {
            model = PerspectiveMapWrapper.this.parent.method_4710().method_3495(PerspectiveMapWrapper.this.parent, stack, worldIn, entityIn, seed);
            return new PerspectiveMapWrapper(model, PerspectiveMapWrapper.this.transforms);
        }
    }
}

