/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.IModelBuilder;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometryPart;
import io.github.fabricators_of_create.porting_lib.model.ISimpleModelGeometry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;

public interface IMultipartModelGeometry<T extends IMultipartModelGeometry<T>>
extends ISimpleModelGeometry<T> {
    @Override
    public Collection<? extends IModelGeometryPart> getParts();

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String var1);

    @Override
    default public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
        this.getParts().stream().filter(part -> owner.getPartVisibility((IModelGeometryPart)part)).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
    }

    @Override
    default public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet combined = Sets.newHashSet();
        for (IModelGeometryPart part : this.getParts()) {
            combined.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return combined;
    }
}

