/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometryPart;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.model.SimpleModelState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class BlockModelConfiguration
implements IModelConfiguration {
    public final class_793 owner;
    public final VisibilityData visibilityData = new VisibilityData();
    @Nullable
    private IModelGeometry<?> customGeometry;
    @Nullable
    private class_3665 customModelState;

    public BlockModelConfiguration(class_793 owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public class_1100 getOwnerModel() {
        return this.owner;
    }

    @Override
    public String getModelName() {
        return this.owner.field_4252;
    }

    public boolean hasCustomGeometry() {
        return this.getCustomGeometry() != null;
    }

    @Nullable
    public IModelGeometry<?> getCustomGeometry() {
        return this.owner.field_4253 != null && this.customGeometry == null ? this.owner.field_4253.getGeometry().getCustomGeometry() : this.customGeometry;
    }

    public void setCustomGeometry(IModelGeometry<?> geometry) {
        this.customGeometry = geometry;
    }

    @Nullable
    public class_3665 getCustomModelState() {
        return this.owner.field_4253 != null && this.customModelState == null ? this.owner.field_4253.getGeometry().getCustomModelState() : this.customModelState;
    }

    public void setCustomModelState(class_3665 modelState) {
        this.customModelState = modelState;
    }

    @Override
    public boolean getPartVisibility(IModelGeometryPart part, boolean fallback) {
        return this.owner.field_4253 != null && !this.visibilityData.hasCustomVisibility(part) ? this.owner.field_4253.getGeometry().getPartVisibility(part, fallback) : this.visibilityData.isVisible(part, fallback);
    }

    @Override
    public boolean isTexturePresent(String name) {
        return this.owner.method_3432(name);
    }

    @Override
    public class_4730 resolveTexture(String name) {
        return this.owner.method_24077(name);
    }

    @Override
    public boolean isShadedInGui() {
        return true;
    }

    @Override
    public boolean isSideLit() {
        return this.owner.method_24298().method_24299();
    }

    @Override
    public boolean useSmoothLighting() {
        return this.owner.method_3444();
    }

    @Override
    public class_809 getCameraTransforms() {
        return this.owner.method_3443();
    }

    @Override
    public class_3665 getCombinedTransform() {
        class_3665 state = this.getCustomModelState();
        return state != null ? new SimpleModelState(PerspectiveMapWrapper.getTransformsWithFallback(state, this.getCameraTransforms()), state.method_3509()) : new SimpleModelState(PerspectiveMapWrapper.getTransforms(this.getCameraTransforms()));
    }

    public void copyFrom(BlockModelConfiguration other) {
        this.customGeometry = other.customGeometry;
        this.customModelState = other.customModelState;
        this.visibilityData.copyFrom(other.visibilityData);
    }

    public Collection<class_4730> getTextureDependencies(Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        return geometry == null ? Collections.emptySet() : geometry.getTextures(this, modelGetter, missingTextureErrors);
    }

    public class_1087 bake(class_1088 bakery, Function<class_4730, class_1058> bakedTextureGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        if (geometry == null) {
            throw new IllegalStateException("Can not use custom baking without custom geometry");
        }
        return geometry.bake(this, bakery, bakedTextureGetter, modelTransform, overrides, modelLocation);
    }

    public static class VisibilityData {
        private final Map<String, Boolean> data = new HashMap<String, Boolean>();

        public boolean hasCustomVisibility(IModelGeometryPart part) {
            return this.data.containsKey(part.name());
        }

        public boolean isVisible(IModelGeometryPart part, boolean fallback) {
            return this.data.getOrDefault(part.name(), fallback);
        }

        public void setVisibilityState(String partName, boolean type) {
            this.data.put(partName, type);
        }

        public void copyFrom(VisibilityData visibilityData) {
            this.data.clear();
            this.data.putAll(visibilityData.data);
        }
    }
}

