/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.block.CustomFrictionBlock;
import io.github.fabricators_of_create.porting_lib.block.CustomLandingEffectsBlock;
import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityUseItemEvents;
import io.github.fabricators_of_create.porting_lib.event.common.PotionEvents;
import io.github.fabricators_of_create.porting_lib.extensions.EntityExtensions;
import io.github.fabricators_of_create.porting_lib.item.EntitySwingListenerItem;
import io.github.fabricators_of_create.porting_lib.item.EquipmentItem;
import io.github.fabricators_of_create.porting_lib.util.ContinueUsingItem;
import io.github.fabricators_of_create.porting_lib.util.UsingTickItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class}, priority=500)
public abstract class LivingEntityMixin
extends class_1297
implements EntityExtensions {
    @Shadow
    protected class_1657 field_6258;
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    @Unique
    private LivingEntityEvents.Fall.FallEvent port_lib$currentFallEvent = null;
    private static final class_1322 SLOW_FALLING = new class_1322(UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA"), "Slow falling acceleration reduction", -0.07, class_1322.class_1323.field_6328);

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    @Nullable
    public abstract class_1324 method_5996(class_1320 var1);

    @Shadow
    public abstract class_1799 method_6030();

    @Shadow
    public abstract int method_6014();

    @Shadow
    public abstract class_1268 method_6058();

    public LivingEntityMixin(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void port_lib$addModdedAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(PortingLibAttributes.ENTITY_GRAVITY).method_26867(PortingLibAttributes.SWIM_SPEED);
    }

    @ModifyArgs(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropCustomDeathLoot(Lnet/minecraft/world/damagesource/DamageSource;IZ)V"))
    private void port_lib$modifyLootingLevel(Args args) {
        class_1282 source = (class_1282)args.get(0);
        int originalLevel = (Integer)args.get(1);
        boolean recentlyHit = (Boolean)args.get(2);
        int modifiedLevel = ((LivingEntityEvents.LootingLevel)LivingEntityEvents.LOOTING_LEVEL.invoker()).modifyLootingLevel(source, (class_1309)this, originalLevel, recentlyHit);
        args.set(1, (Object)modifiedLevel);
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="JUMP", opcode=158, ordinal=0)})
    public void port_lib$fixNullDrops(class_1282 damageSource, CallbackInfo ci) {
        this.captureDrops(new ArrayList());
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    private void port_lib$spawnDropsTAIL(class_1282 source, CallbackInfo ci) {
        Collection drops = this.captureDrops(null);
        if (!((LivingEntityEvents.Drops)LivingEntityEvents.DROPS.invoker()).onLivingEntityDrops((class_1309)this, source, drops)) {
            drops.forEach(e -> this.field_6002.method_8649((class_1297)e));
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$cancelFall(float fallDistance, float multiplier, class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        this.port_lib$currentFallEvent = new LivingEntityEvents.Fall.FallEvent((class_1309)this, source, fallDistance, multiplier);
        this.port_lib$currentFallEvent.sendEvent();
        if (this.port_lib$currentFallEvent.isCanceled()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float port_lib$modifyDistance(float fallDistance) {
        if (this.port_lib$currentFallEvent != null) {
            return this.port_lib$currentFallEvent.getDistance();
        }
        return fallDistance;
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    public float port_lib$modifyMultiplier(float multiplier) {
        if (this.port_lib$currentFallEvent != null) {
            return this.port_lib$currentFallEvent.getDamageMultiplier();
        }
        return multiplier;
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float port_lib$modifyDamage(float damageAmount, class_1282 source, float damageAmountButAgainBecauseYes) {
        return ((LivingEntityEvents.ActuallyHurt)LivingEntityEvents.ACTUALLY_HURT.invoker()).onHurt(source, (class_1309)this, damageAmount);
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void port_lib$swingHand(class_1268 hand, boolean bl, CallbackInfo ci) {
        EntitySwingListenerItem listener;
        class_1792 class_17922;
        class_1799 stack = this.method_5998(hand);
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof EntitySwingListenerItem && (listener = (EntitySwingListenerItem)class_17922).onEntitySwing(stack, (class_1309)this)) {
            ci.cancel();
        }
    }

    @ModifyArgs(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private void create$dropExperience(Args args) {
        int newAmount;
        int amount = (Integer)args.get(2);
        if (amount != (newAmount = ((LivingEntityEvents.ExperienceDrop)LivingEntityEvents.EXPERIENCE_DROP.invoker()).onLivingEntityExperienceDrop(amount, this.field_6258))) {
            args.set(2, (Object)newAmount);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private void port_lib$tick(CallbackInfo ci) {
        ((LivingEntityEvents.Tick)LivingEntityEvents.TICK.invoker()).onLivingEntityTick((class_1309)this);
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private double port_lib$takeKnockback(double f) {
        if (this.field_6258 != null) {
            return ((LivingEntityEvents.KnockBackStrength)LivingEntityEvents.KNOCKBACK_STRENGTH.invoker()).onLivingEntityTakeKnockback(f, this.field_6258);
        }
        return f;
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float port_lib$onHurt(float amount, class_1282 source, float amount2) {
        return ((LivingEntityEvents.Hurt)LivingEntityEvents.HURT.invoker()).onHurt(source, amount);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    public void port_lib$onJump(CallbackInfo ci) {
        ((LivingEntityEvents.Jump)LivingEntityEvents.JUMP.invoker()).onLivingEntityJump((class_1309)this);
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    protected void port_lib$updateFallState(double y, boolean onGround, class_2680 state, class_2338 pos, CallbackInfo ci, float f, double d, int i) {
        CustomLandingEffectsBlock custom;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CustomLandingEffectsBlock && (custom = (CustomLandingEffectsBlock)class_22482).addLandingEffects(state, (class_3218)this.field_6002, pos, state, (class_1309)this, i)) {
            super.method_5623(y, onGround, state, pos);
            ci.cancel();
        }
    }

    @ModifyVariable(method={"travel"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getBlockPosBelowThatAffectsMyMovement()Lnet/minecraft/core/BlockPos;")), at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/block/Block;getFriction()F"))
    public float port_lib$setSlipperiness(float p) {
        class_2338 pos = this.method_23314();
        class_2680 state = this.field_6002.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CustomFrictionBlock) {
            CustomFrictionBlock custom = (CustomFrictionBlock)class_22482;
            return custom.getFriction(state, (class_4538)this.field_6002, pos, (class_1297)((class_1309)this));
        }
        return p;
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=0)})
    private boolean port_lib$disableOldLogicFallingLogic(boolean original) {
        return false;
    }

    @Inject(method={"travel"}, at={@At(value="CONSTANT", args={"doubleValue=0.08D"})})
    public void port_lib$entityGravity(class_243 travelVector, CallbackInfo ci) {
        class_1324 gravity = this.method_5996(PortingLibAttributes.ENTITY_GRAVITY);
        if (gravity != null) {
            boolean falling;
            boolean bl = falling = this.method_18798().field_1351 <= 0.0;
            if (falling && this.method_6059(class_1294.field_5906)) {
                if (!gravity.method_6196(SLOW_FALLING)) {
                    gravity.method_26835(SLOW_FALLING);
                }
                this.method_38785();
            } else if (gravity.method_6196(SLOW_FALLING)) {
                gravity.method_6202(SLOW_FALLING);
            }
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="STORE", ordinal=0))
    private double port_lib$modifyGravity(double original) {
        class_1324 attribute;
        if (original == 0.08 && (attribute = this.method_5996(PortingLibAttributes.ENTITY_GRAVITY)) != null) {
            return attribute.method_6194();
        }
        return original;
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", shift=At.Shift.BY, by=2, target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$onFinishUsing(CallbackInfo ci, class_1268 hand, class_1799 result) {
        ((LivingEntityUseItemEvents.LivingUseItemFinish)LivingEntityUseItemEvents.LIVING_USE_ITEM_FINISH.invoker()).onUseItem((class_1309)this, this.method_6030().method_7972(), this.method_6014(), result);
    }

    @Inject(method={"getEquipmentSlotForItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void port_lib$getSlotForItemStack(class_1799 itemStack, CallbackInfoReturnable<class_1304> cir) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof EquipmentItem) {
            EquipmentItem equipment = (EquipmentItem)class_17922;
            cir.setReturnValue((Object)equipment.getEquipmentSlot(itemStack));
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.BY, by=3, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$addEffect(class_1293 newEffect, @Nullable class_1297 source, CallbackInfoReturnable<Boolean> cir, class_1293 oldEffect) {
        ((PotionEvents.PotionAdded)PotionEvents.POTION_ADDED.invoker()).onPotionAdded((class_1309)this, newEffect, oldEffect, source);
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$canBeAffected(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        class_1269 result = ((PotionEvents.PotionApplicable)PotionEvents.POTION_APPLICABLE.invoker()).onPotionApplicable((class_1309)this, effect);
        if (result != class_1269.field_5811) {
            cir.setReturnValue((Object)(result == class_1269.field_5812 ? 1 : 0));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$attackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((LivingEntityEvents.Attack)LivingEntityEvents.ATTACK.invoker()).onAttack((class_1309)this, source, amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="JUMP", opcode=199)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$equipmentChange(CallbackInfoReturnable<Map<class_1304, class_1799>> cir, Map<class_1304, class_1799> map, class_1304[] equipmentslots, int i, int j, class_1304 equipmentslot, class_1799 itemstack, class_1799 itemstack1) {
        ((LivingEntityEvents.EquipmentChange)LivingEntityEvents.EQUIPMENT_CHANGE.invoker()).onEquipmentChange((class_1309)this, equipmentslot, itemstack, itemstack1);
    }

    @Inject(method={"updatingUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.AFTER, ordinal=1)})
    public void port_lib$onUsingTick(CallbackInfo ci) {
        class_1792 class_17922 = this.field_6277.method_7909();
        if (class_17922 instanceof UsingTickItem) {
            UsingTickItem usingTickItem = (UsingTickItem)class_17922;
            if (!this.field_6277.method_7960() && this.field_6222 > 0) {
                usingTickItem.onUsingTick(this.field_6277, (class_1309)this, this.field_6222);
            }
        }
    }

    @ModifyExpressionValue(method={"updatingUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isSameIgnoreDurability(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean port_lib$canContinueUsing(boolean original) {
        class_1792 class_17922 = this.field_6277.method_7909();
        if (class_17922 instanceof ContinueUsingItem) {
            ContinueUsingItem continueUsingItem = (ContinueUsingItem)class_17922;
            class_1799 to = this.method_5998(this.method_6058());
            if (!this.field_6277.method_7960() && !to.method_7960()) {
                return continueUsingItem.canContinueUsing(this.field_6277, to);
            }
            return false;
        }
        return original;
    }
}

